# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbvtk is found.  
# If bbvtk is not found, bbvtk_FOUND is set to false.
#  bbvtk_FOUND         - Set to true when bbvtk is found.
#  bbvtk_USE_FILE      - CMake file to use bbvtk.
#  bbvtk_MAJOR_VERSION - The bbvtk major version number.
#  bbvtk_MINOR_VERSION - The bbvtk minor version number 
#                       (odd non-release).
#  bbvtk_BUILD_VERSION - The bbvtk patch level 
#                       (meaningless for odd minor).
#  bbvtk_INCLUDE_DIRS  - Include directories for bbvtk
#  bbvtk_LIBRARY_DIRS  - Link directories for bbvtk libraries
#  bbvtk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbvtk:
#  bbvtk_DIR  - The directory containing bbvtkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbvtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbvtk_DIR_DESCRIPTION "directory containing bbvtkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbvtk for an installation.")
SET(bbvtk_NOT_FOUND_MESSAGE "bbvtk not found.  Set the bbvtk_DIR cmake cache entry to the ${bbvtk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbvtk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbvtk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbvtk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbvtk_DIR_SEARCH2 "${bbvtk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbvtk_DIR_SEARCH "")
  FOREACH(dir ${bbvtk_DIR_SEARCH2})
    SET(bbvtk_DIR_SEARCH ${bbvtk_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbvtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbvtk_DIR Usebbvtk.cmake
    # Look for an environment variable bbvtk_DIR.
    $ENV{bbvtk_DIR}

    # Look in places relative to the system executable search path.
    ${bbvtk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbvtk"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbvtk
    /usr/lib64/creatools/bbvtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbvtk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbvtk_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbvtk_DIR)

# If bbvtk was found, load the configuration file to get the rest of the
# settings.
IF(bbvtk_DIR)
  # Make sure the bbvtkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbvtk_DIR}/bbvtkConfig.cmake)

    # We found bbvtk.  Load the settings.
    SET(bbvtk_FOUND 1)
    INCLUDE(${bbvtk_DIR}/bbvtkConfig.cmake)

  ENDIF(EXISTS ${bbvtk_DIR}/bbvtkConfig.cmake)
ELSE(bbvtk_DIR)
  # We did not find bbvtk.
  SET(bbvtk_FOUND 0)
ENDIF(bbvtk_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbvtk_FOUND)
  # bbvtk not found, explain to the user how to specify its location.
  IF(NOT bbvtk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbvtk_NOT_FOUND_MESSAGE})
  ELSE(NOT bbvtk_FIND_QUIETLY)
    IF(bbvtk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbvtk_NOT_FOUND_MESSAGE})
    ENDIF(bbvtk_FIND_REQUIRED)
  ENDIF(NOT bbvtk_FIND_QUIETLY)
ENDIF(NOT bbvtk_FOUND)
