# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaBruker is found.  
# If creaBruker is not found, creaBruker_FOUND is set to false.
#  creaBruker_FOUND         - Set to true when creaBruker is found.
#  creaBruker_USE_FILE      - CMake file to use creaBruker.
#  creaBruker_MAJOR_VERSION - The creaBruker major version number.
#  creaBruker_MINOR_VERSION - The creaBruker minor version number 
#                       (odd non-release).
#  creaBruker_BUILD_VERSION - The creaBruker patch level 
#                       (meaningless for odd minor).
#  creaBruker_INCLUDE_DIRS  - Include directories for creaBruker
#  creaBruker_LIBRARY_DIRS  - Link directories for creaBruker libraries
#  creaBruker_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaBruker:
#  creaBruker_DIR  - The directory containing creaBrukerConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaBruker directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaBruker_DIR_DESCRIPTION "directory containing creaBrukerConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaBruker for an installation.")
SET(creaBruker_NOT_FOUND_MESSAGE "creaBruker not found.  Set the creaBruker_DIR cmake cache entry to the ${creaBruker_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaBruker_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaBruker_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaBruker_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaBruker_DIR_SEARCH2 "${creaBruker_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaBruker_DIR_SEARCH "")
  FOREACH(dir ${creaBruker_DIR_SEARCH2})
    SET(creaBruker_DIR_SEARCH ${creaBruker_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaBruker
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaBruker_DIR UsecreaBruker.cmake
    # Look for an environment variable creaBruker_DIR.
    $ENV{creaBruker_DIR}

    # Look in places relative to the system executable search path.
    ${creaBruker_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaBruker"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaBruker
    /usr/lib64/creatools/creaBruker

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaBruker will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaBruker_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaBruker_DIR)

# If creaBruker was found, load the configuration file to get the rest of the
# settings.
IF(creaBruker_DIR)
  # Make sure the creaBrukerConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaBruker_DIR}/creaBrukerConfig.cmake)

    # We found creaBruker.  Load the settings.
    SET(creaBruker_FOUND 1)
    INCLUDE(${creaBruker_DIR}/creaBrukerConfig.cmake)

  ENDIF(EXISTS ${creaBruker_DIR}/creaBrukerConfig.cmake)
ELSE(creaBruker_DIR)
  # We did not find creaBruker.
  SET(creaBruker_FOUND 0)
ENDIF(creaBruker_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaBruker_FOUND)
  # creaBruker not found, explain to the user how to specify its location.
  IF(NOT creaBruker_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaBruker_NOT_FOUND_MESSAGE})
  ELSE(NOT creaBruker_FIND_QUIETLY)
    IF(creaBruker_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaBruker_NOT_FOUND_MESSAGE})
    ENDIF(creaBruker_FIND_REQUIRED)
  ENDIF(NOT creaBruker_FIND_QUIETLY)
ENDIF(NOT creaBruker_FOUND)
