# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaContours is found.  
# If creaContours is not found, creaContours_FOUND is set to false.
#  creaContours_FOUND         - Set to true when creaContours is found.
#  creaContours_USE_FILE      - CMake file to use creaContours.
#  creaContours_MAJOR_VERSION - The creaContours major version number.
#  creaContours_MINOR_VERSION - The creaContours minor version number 
#                       (odd non-release).
#  creaContours_BUILD_VERSION - The creaContours patch level 
#                       (meaningless for odd minor).
#  creaContours_INCLUDE_DIRS  - Include directories for creaContours
#  creaContours_LIBRARY_DIRS  - Link directories for creaContours libraries
#  creaContours_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaContours:
#  creaContours_DIR  - The directory containing creaContoursConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaContours directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaContours_DIR_DESCRIPTION "directory containing creaContoursConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaContours for an installation.")
SET(creaContours_NOT_FOUND_MESSAGE "creaContours not found.  Set the creaContours_DIR cmake cache entry to the ${creaContours_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaContours_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaContours_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaContours_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaContours_DIR_SEARCH2 "${creaContours_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaContours_DIR_SEARCH "")
  FOREACH(dir ${creaContours_DIR_SEARCH2})
    SET(creaContours_DIR_SEARCH ${creaContours_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaContours
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaContours_DIR UsecreaContours.cmake
    # Look for an environment variable creaContours_DIR.
    $ENV{creaContours_DIR}

    # Look in places relative to the system executable search path.
    ${creaContours_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaContours"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaContours
    /usr/lib64/creatools/creaContours

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaContours will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaContours_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaContours_DIR)

# If creaContours was found, load the configuration file to get the rest of the
# settings.
IF(creaContours_DIR)
  # Make sure the creaContoursConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaContours_DIR}/creaContoursConfig.cmake)

    # We found creaContours.  Load the settings.
    SET(creaContours_FOUND 1)
    INCLUDE(${creaContours_DIR}/creaContoursConfig.cmake)

  ENDIF(EXISTS ${creaContours_DIR}/creaContoursConfig.cmake)
ELSE(creaContours_DIR)
  # We did not find creaContours.
  SET(creaContours_FOUND 0)
ENDIF(creaContours_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaContours_FOUND)
  # creaContours not found, explain to the user how to specify its location.
  IF(NOT creaContours_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaContours_NOT_FOUND_MESSAGE})
  ELSE(NOT creaContours_FIND_QUIETLY)
    IF(creaContours_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaContours_NOT_FOUND_MESSAGE})
    ENDIF(creaContours_FIND_REQUIRED)
  ENDIF(NOT creaContours_FIND_QUIETLY)
ENDIF(NOT creaContours_FOUND)
