# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaImageIO is found.  
# If creaImageIO is not found, creaImageIO_FOUND is set to false.
#  creaImageIO_FOUND         - Set to true when creaImageIO is found.
#  creaImageIO_USE_FILE      - CMake file to use creaImageIO.
#  creaImageIO_MAJOR_VERSION - The creaImageIO major version number.
#  creaImageIO_MINOR_VERSION - The creaImageIO minor version number 
#                       (odd non-release).
#  creaImageIO_BUILD_VERSION - The creaImageIO patch level 
#                       (meaningless for odd minor).
#  creaImageIO_INCLUDE_DIRS  - Include directories for creaImageIO
#  creaImageIO_LIBRARY_DIRS  - Link directories for creaImageIO libraries
#  creaImageIO_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaImageIO:
#  creaImageIO_DIR  - The directory containing creaImageIOConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaImageIO directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaImageIO_DIR_DESCRIPTION "directory containing creaImageIOConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaImageIO for an installation.")
SET(creaImageIO_NOT_FOUND_MESSAGE "creaImageIO not found.  Set the creaImageIO_DIR cmake cache entry to the ${creaImageIO_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaImageIO_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaImageIO_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaImageIO_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaImageIO_DIR_SEARCH2 "${creaImageIO_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaImageIO_DIR_SEARCH "")
  FOREACH(dir ${creaImageIO_DIR_SEARCH2})
    SET(creaImageIO_DIR_SEARCH ${creaImageIO_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaImageIO
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaImageIO_DIR UsecreaImageIO.cmake
    # Look for an environment variable creaImageIO_DIR.
    $ENV{creaImageIO_DIR}

    # Look in places relative to the system executable search path.
    ${creaImageIO_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaImageIO"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaImageIO
    /usr/lib64/creatools/creaImageIO

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaImageIO will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaImageIO_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaImageIO_DIR)

# If creaImageIO was found, load the configuration file to get the rest of the
# settings.
IF(creaImageIO_DIR)
  # Make sure the creaImageIOConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaImageIO_DIR}/creaImageIOConfig.cmake)

    # We found creaImageIO.  Load the settings.
    SET(creaImageIO_FOUND 1)
    INCLUDE(${creaImageIO_DIR}/creaImageIOConfig.cmake)

  ENDIF(EXISTS ${creaImageIO_DIR}/creaImageIOConfig.cmake)
ELSE(creaImageIO_DIR)
  # We did not find creaImageIO.
  SET(creaImageIO_FOUND 0)
ENDIF(creaImageIO_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaImageIO_FOUND)
  # creaImageIO not found, explain to the user how to specify its location.
  IF(NOT creaImageIO_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaImageIO_NOT_FOUND_MESSAGE})
  ELSE(NOT creaImageIO_FIND_QUIETLY)
    IF(creaImageIO_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaImageIO_NOT_FOUND_MESSAGE})
    ENDIF(creaImageIO_FIND_REQUIRED)
  ENDIF(NOT creaImageIO_FIND_QUIETLY)
ENDIF(NOT creaImageIO_FOUND)
