# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaMaracasVisu is found.  
# If creaMaracasVisu is not found, creaMaracasVisu_FOUND is set to false.
#  creaMaracasVisu_FOUND         - Set to true when creaMaracasVisu is found.
#  creaMaracasVisu_USE_FILE      - CMake file to use creaMaracasVisu.
#  creaMaracasVisu_MAJOR_VERSION - The creaMaracasVisu major version number.
#  creaMaracasVisu_MINOR_VERSION - The creaMaracasVisu minor version number 
#                       (odd non-release).
#  creaMaracasVisu_BUILD_VERSION - The creaMaracasVisu patch level 
#                       (meaningless for odd minor).
#  creaMaracasVisu_INCLUDE_DIRS  - Include directories for creaMaracasVisu
#  creaMaracasVisu_LIBRARY_DIRS  - Link directories for creaMaracasVisu libraries
#  creaMaracasVisu_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaMaracasVisu:
#  creaMaracasVisu_DIR  - The directory containing creaMaracasVisuConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaMaracasVisu directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaMaracasVisu_DIR_DESCRIPTION "directory containing creaMaracasVisuConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaMaracasVisu for an installation.")
SET(creaMaracasVisu_NOT_FOUND_MESSAGE "creaMaracasVisu not found.  Set the creaMaracasVisu_DIR cmake cache entry to the ${creaMaracasVisu_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaMaracasVisu_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaMaracasVisu_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaMaracasVisu_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaMaracasVisu_DIR_SEARCH2 "${creaMaracasVisu_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaMaracasVisu_DIR_SEARCH "")
  FOREACH(dir ${creaMaracasVisu_DIR_SEARCH2})
    SET(creaMaracasVisu_DIR_SEARCH ${creaMaracasVisu_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaMaracasVisu_DIR UsecreaMaracasVisu.cmake
    # Look for an environment variable creaMaracasVisu_DIR.
    $ENV{creaMaracasVisu_DIR}

    # Look in places relative to the system executable search path.
    ${creaMaracasVisu_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaMaracasVisu"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaMaracasVisu
    /usr/lib64/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaMaracasVisu will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaMaracasVisu_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaMaracasVisu_DIR)

# If creaMaracasVisu was found, load the configuration file to get the rest of the
# settings.
IF(creaMaracasVisu_DIR)
  # Make sure the creaMaracasVisuConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaMaracasVisu_DIR}/creaMaracasVisuConfig.cmake)

    # We found creaMaracasVisu.  Load the settings.
    SET(creaMaracasVisu_FOUND 1)
    INCLUDE(${creaMaracasVisu_DIR}/creaMaracasVisuConfig.cmake)

  ENDIF(EXISTS ${creaMaracasVisu_DIR}/creaMaracasVisuConfig.cmake)
ELSE(creaMaracasVisu_DIR)
  # We did not find creaMaracasVisu.
  SET(creaMaracasVisu_FOUND 0)
ENDIF(creaMaracasVisu_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaMaracasVisu_FOUND)
  # creaMaracasVisu not found, explain to the user how to specify its location.
  IF(NOT creaMaracasVisu_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaMaracasVisu_NOT_FOUND_MESSAGE})
  ELSE(NOT creaMaracasVisu_FIND_QUIETLY)
    IF(creaMaracasVisu_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaMaracasVisu_NOT_FOUND_MESSAGE})
    ENDIF(creaMaracasVisu_FIND_REQUIRED)
  ENDIF(NOT creaMaracasVisu_FIND_QUIETLY)
ENDIF(NOT creaMaracasVisu_FOUND)
