# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if creaVtk is found.  
# If creaVtk is not found, creaVtk_FOUND is set to false.
#  creaVtk_FOUND         - Set to true when creaVtk is found.
#  creaVtk_USE_FILE      - CMake file to use creaVtk.
#  creaVtk_MAJOR_VERSION - The creaVtk major version number.
#  creaVtk_MINOR_VERSION - The creaVtk minor version number 
#                       (odd non-release).
#  creaVtk_BUILD_VERSION - The creaVtk patch level 
#                       (meaningless for odd minor).
#  creaVtk_INCLUDE_DIRS  - Include directories for creaVtk
#  creaVtk_LIBRARY_DIRS  - Link directories for creaVtk libraries
#  creaVtk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate creaVtk:
#  creaVtk_DIR  - The directory containing creaVtkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/creaVtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(creaVtk_DIR_DESCRIPTION "directory containing creaVtkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/creaVtk for an installation.")
SET(creaVtk_NOT_FOUND_MESSAGE "creaVtk not found.  Set the creaVtk_DIR cmake cache entry to the ${creaVtk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT creaVtk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" creaVtk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" creaVtk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" creaVtk_DIR_SEARCH2 "${creaVtk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(creaVtk_DIR_SEARCH "")
  FOREACH(dir ${creaVtk_DIR_SEARCH2})
    SET(creaVtk_DIR_SEARCH ${creaVtk_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaVtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(creaVtk_DIR UsecreaVtk.cmake
    # Look for an environment variable creaVtk_DIR.
    $ENV{creaVtk_DIR}

    # Look in places relative to the system executable search path.
    ${creaVtk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/creaVtk"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaVtk
    /usr/lib64/creatools/creaVtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # creaVtk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${creaVtk_DIR_DESCRIPTION}"
  )
ENDIF(NOT creaVtk_DIR)

# If creaVtk was found, load the configuration file to get the rest of the
# settings.
IF(creaVtk_DIR)
  # Make sure the creaVtkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${creaVtk_DIR}/creaVtkConfig.cmake)

    # We found creaVtk.  Load the settings.
    SET(creaVtk_FOUND 1)
    INCLUDE(${creaVtk_DIR}/creaVtkConfig.cmake)

  ENDIF(EXISTS ${creaVtk_DIR}/creaVtkConfig.cmake)
ELSE(creaVtk_DIR)
  # We did not find creaVtk.
  SET(creaVtk_FOUND 0)
ENDIF(creaVtk_DIR)

#-----------------------------------------------------------------------------
IF(NOT creaVtk_FOUND)
  # creaVtk not found, explain to the user how to specify its location.
  IF(NOT creaVtk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${creaVtk_NOT_FOUND_MESSAGE})
  ELSE(NOT creaVtk_FIND_QUIETLY)
    IF(creaVtk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${creaVtk_NOT_FOUND_MESSAGE})
    ENDIF(creaVtk_FIND_REQUIRED)
  ENDIF(NOT creaVtk_FIND_QUIETLY)
ENDIF(NOT creaVtk_FOUND)
