# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------  

#!/bin/bash -e



##########################################
# check that $1 is one of $2, $3, ...
function checkVal  {
    local val=$1
    shift
    for x in $* ; do
        if [ "$val" == "$x" ] ; then
            echo "true"
            return
        fi
    done
    echo "false"
}

###########################################
function bigDisplay {
    echo " ================================================================================================"
    echo " ================================================================================================"
    echo " ======= $1"                                       
    echo " ================================================================================================"
    echo " ================================================================================================"
}

###########################################
function checkDistrib {
    local OS=$1
    if [ "`checkVal $OS MacOS Fedora Ubuntu Mandriva`" == "false" ] ; then
        echo "Operating System not supported: $OS"
        echo "Currently supported system: Fedora Ubuntu MacOS"
        exit 1
    fi
}

###########################################
function getDistrib {
    local OS=`uname`

      if [ "$OS" == Darwin ] ; then OS=MacOS;
    elif [ "$OS" == Linux  ] ; then OS=`awk 'NR==1{print $1}' /etc/system-release`
    else OS=""
    fi
# checkDistrib $OS
    echo $OS
}

###########################################
function getDistribVersion {
    local DISTRIB=`getDistrib`

      if [ "$DISTRIB" == MacOS ] ; then OSVesion=VOID_Darwin_EED;
    elif [ "$DISTRIB" == Fedora  ] ; then OSVersion=`awk 'NR==1{print $3}' /etc/system-release`
    elif [ "$DISTRIB" == Ubuntu  ] ; then OSVersion=`awk 'NR==1{print $2}' /etc/issue`
    else OSVersion="VOID_EED"
    fi
    echo $OSVersion
}

###########################################
function getDownloadCommand {
    local DISTRIB=`getDistrib`

      if [ "$DISTRIB" == MacOS ] ; then downloadCommand=curl;
    elif [ "$DISTRIB" == Fedora  ] ; then downloadCommand='aria2c -x 16'
    elif [ "$DISTRIB" == Ubuntu  ] ; then downloadCommand=wget
    else downloadCommand="VOID_EED"
    fi
    echo $downloadCommand
}

###########################################
function getncore {
    if [ `uname` == Darwin ] ; then # MacOS
        system_profiler | grep Processor | awk '$1=="Number" {print $4}'
    else
        cat /proc/cpuinfo | grep processor | wc -l
    fi
}

###########################################
function getbashrc {
    if [ ! -f $HOME/.bashrc ] ; then
        touch $HOME/.bashrc
    fi
    echo $HOME/.bashrc


#    # Do it, while we are under user, not under root! # JPR
#    if [ -f $HOME/.bashrc ] ; then
#        echo $HOME/.bashrc
#    else
#        if [ -f $HOME/.profile ] ; then
#            echo $HOME/.profile
#        else
#            echo "=============== BIG TROUBLE : neither $HOME/.bashrc nor $HOME/.profile file found" > /dev/stderr
#            echo "=============== You'd better abort the program and (try to) fix the issue" > /dec/stderr
#            read a # just to let the user time enough to read the message...
#        fi
#    fi
}


###########################################
function printconfig {
    echo
    echo "Current Configuration:"
    echo "  Operating System                           : $OperatingSystem"
    echo "  Number of Cores                            : $corenumber"	
    echo "  Name of the Generation Directory           : $generationdir"
    echo "  Install Prefix for Third Party Libraries   : $installPrefixThird"	
    echo "  Install Prefix for CreaTools               : $installPrefix"
    echo "  Boolean for Doc Generation                 : $docgeneration"
    echo "  Where do you want to get source files from : $sourcesFrom"
    echo "  Login User Name                            : $loginUserName"
    echo "  Login Group Name                           : $loginGroupName"
    echo "  Build type                                 : $buildType"          
    echo "  Gdcm version                               : $gdcmVersion"
    echo "  ITK version                                : $ITKVersion"
    echo
}


