/*=========================================================================
                                                                                
  Program:   gdcm
  Module:    $RCSfile: gdcmConfigure.h.in,v $
  Language:  C++
  Date:      $Date: 2007/05/23 14:18:03 $
  Version:   $Revision: 1.22 $
                                                                                
  Copyright (c) CREATIS (Centre de Recherche et d'Applications en Traitement de
  l'Image). All rights reserved. See Doc/License.txt or
  http://www.creatis.insa-lyon.fr/Public/Gdcm/License.html for details.
                                                                                
     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.
                                                                                
=========================================================================*/

#ifndef __gdcmConfigure_h
#define __gdcmConfigure_h

/* This header is configured by GDCM's build process.  */

/*--------------------------------------------------------------------------*/
/* Platform Features                                                        */

/* Byte order.  */
/* #undef GDCM_WORDS_BIGENDIAN */

/* Allow access to UINT32_MAX , cf gdcmCommon.h */
#define __STDC_LIMIT_MACROS

/* Hard code the path to the public dictionary */
#define PUB_DICT_PATH "/home/davila/Creatis/creaTools/thirdparty_sources/gdcm/Dicts"

/* Hardcode the path to GDCM_DATA_ROOT */
#define GDCM_DATA_ROOT "GDCM_DATA_ROOT-NOTFOUND"

/* Usefull in particular for loadshared where the full path
 * to the lib is needed */
#define GDCM_EXECUTABLE_OUTPUT_PATH "/home/davila/Creatis/creaTools/thirdparty_bin/gdcm-Bin/bin"
#define GDCM_LIBRARY_OUTPUT_PATH    "/home/davila/Creatis/creaTools/thirdparty_bin/gdcm-Bin/bin"

/* For older gcc / broken plateform */
/* #undef GDCM_NO_ANSI_STRING_STREAM */

/* I guess something important */
#define CMAKE_HAVE_STDINT_H
#define CMAKE_HAVE_INTTYPES_H

/* This variable allows you to have helpful debug statement */
/* That are in between #ifdef / endif in the gdcm code */
/* That means if GDCM_DEBUG is OFF there shouldn't be any 'cout' at all ! */
/* only cerr, for instance 'invalid file' will be allowed */
/* #undef GDCM_DEBUG */

/* Whether we are building shared libraries.  */
/* This was important as long as GDCM is LGPL */
#define BUILD_SHARED_LIBS

/* GDCM uses __FUNCTION__ which is not ANSI C, but C99 */
#define GDCM_COMPILER_HAS_FUNCTION

#define GDCM_SIZEOF_LONG 

/* Special time structure support */
#define CMAKE_HAVE_SYS_TIMES_H
#define CMAKE_HAVE_SYS_TIMEB_H

/* GetMacAddress require a lot of include file to access low level API */
#define CMAKE_HAVE_UNISTD_H
#define CMAKE_HAVE_STDLIB_H
#define CMAKE_HAVE_SYS_IOCTL_H
#define CMAKE_HAVE_SYS_SOCKET_H
/* #undef CMAKE_HAVE_SYS_SOCKIO_H */
#define CMAKE_HAVE_NET_IF_H
#define CMAKE_HAVE_NETINET_IN_H
/* #undef CMAKE_HAVE_NET_IF_DL_H */
#define CMAKE_HAVE_NET_IF_ARP_H
/* #undef HAVE_SA_LEN */

/* #undef GDCM_FORCE_BIGENDIAN_EMULATION */

/*--------------------------------------------------------------------------*/
/* GDCM Versioning                                                          */

/* Version number.  */
#define GDCM_MAJOR_VERSION 1
#define GDCM_MINOR_VERSION 3
#define GDCM_BUILD_VERSION 2
#define GDCM_VERSION "1.3.2"

/*--------------------------------------------------------------------------*/
/* GDCM deprecation mechanism                                               */
/* #undef GDCM_LEGACY_REMOVE */
/* #undef GDCM_LEGACY_SILENT */

/*--------------------------------------------------------------------------*/
/* Will be usefull to use 2 different versions of gdcm.                     */
/* e.g. : ITK uses gdcm1.2; vtkgdcmImageReader uses gdcm1.3                 */
    
#define GDCM_NAME_SPACE gdcm13

#endif
