#
# This file sets up include directories, link directories, and
# compiler settings for a project to use ITK.  It should not be
# included directly, but rather through the ITK_USE_FILE setting
# obtained from ITKConfig.cmake.
#

IF(ITK_BUILD_SETTINGS_FILE AND NOT SKIP_ITK_BUILD_SETTINGS_FILE)
  INCLUDE(${CMAKE_ROOT}/Modules/CMakeImportBuildSettings.cmake)
  CMAKE_IMPORT_BUILD_SETTINGS(${ITK_BUILD_SETTINGS_FILE})
ENDIF(ITK_BUILD_SETTINGS_FILE AND NOT SKIP_ITK_BUILD_SETTINGS_FILE)

# Add compiler flags needed to use ITK.
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${ITK_REQUIRED_C_FLAGS}")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${ITK_REQUIRED_CXX_FLAGS}")
SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${ITK_REQUIRED_LINK_FLAGS}")
SET(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} ${ITK_REQUIRED_LINK_FLAGS}")
SET(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} ${ITK_REQUIRED_LINK_FLAGS}")

# Add include directories needed to use ITK.
INCLUDE_DIRECTORIES(BEFORE ${ITK_INCLUDE_DIRS})

# Add link directories needed to use ITK.
LINK_DIRECTORIES(${ITK_LIBRARY_DIRS})

# Load settings fro the system VXL with which ITK was built, if any.
IF(ITK_USE_SYSTEM_VXL)
  # If VXL has already been found, make sure it is the one used to
  # build ITK.
  IF(WIN32 OR APPLE)
    STRING(TOLOWER "${VXL_DIR}" ITK_CHECK_VXL_DIR)
    STRING(TOLOWER "${ITK_VXL_DIR}" ITK_CHECK_ITK_VXL_DIR)
  ELSE(WIN32 OR APPLE)
    SET(ITK_CHECK_VXL_DIR "${VXL_DIR}")
    SET(ITK_CHECK_ITK_VXL_DIR "${ITK_VXL_DIR}")
  ENDIF(WIN32 OR APPLE)
  STRING(COMPARE EQUAL "${ITK_CHECK_VXL_DIR}" "${ITK_CHECK_ITK_VXL_DIR}"
         ITK_VXL_DIR_MATCH)
  IF(VXL_FOUND)
    IF(NOT ITK_VXL_DIR_MATCH)
      MESSAGE(FATAL_ERROR
        "ITK was built with VXL from \"${ITK_VXL_DIR}\", "
        "but this project is using VXL from \"${VXL_DIR}\".  "
        "Please set VXL_DIR to match the one used to build ITK."
        )
    ENDIF(NOT ITK_VXL_DIR_MATCH)
  ELSE(VXL_FOUND)
    IF(VXL_DIR)
      IF(NOT ITK_VXL_DIR_MATCH)
        MESSAGE(
          "Warning: ITK was built with VXL from \"${ITK_VXL_DIR}\", "
          "but this project has set VXL_DIR to \"${VXL_DIR}\".  "
          "ITK is changing VXL_DIR to match the VXL with which it was built."
          )
      ENDIF(NOT ITK_VXL_DIR_MATCH)
    ENDIF(VXL_DIR)
    SET(VXL_DIR ${ITK_VXL_DIR})
    FIND_PACKAGE(VXL)
    IF(VXL_FOUND)
      INCLUDE(${VXL_CMAKE_DIR}/UseVXL.cmake)
    ELSE(VXL_FOUND)
      MESSAGE(FATAL_ERROR
        "UseITK could not load VXL settings from \"${VXL_DIR}\" even through "
        "ITK was built using VXL from this location."
        )
    ENDIF(VXL_FOUND)
  ENDIF(VXL_FOUND)
ENDIF(ITK_USE_SYSTEM_VXL)


# Load settings from the system GDCM with which ITK was built, if any.
IF(ITK_USE_SYSTEM_GDCM)
  # If GDCM has already been found, make sure it is the one used to
  # build ITK.
  IF(WIN32 OR APPLE)
    STRING(TOLOWER "${GDCM_DIR}" ITK_CHECK_GDCM_DIR)
    STRING(TOLOWER "${ITK_GDCM_DIR}" ITK_CHECK_ITK_GDCM_DIR)
  ELSE(WIN32 OR APPLE)
    SET(ITK_CHECK_GDCM_DIR "${GDCM_DIR}")
    SET(ITK_CHECK_ITK_GDCM_DIR "${ITK_GDCM_DIR}")
  ENDIF(WIN32 OR APPLE)
  STRING(COMPARE EQUAL "${ITK_CHECK_GDCM_DIR}" "${ITK_CHECK_ITK_GDCM_DIR}"
         ITK_GDCM_DIR_MATCH)
  IF(GDCM_FOUND)
    IF(NOT ITK_GDCM_DIR_MATCH)
      MESSAGE(FATAL_ERROR
        "ITK was built with GDCM from \"${ITK_GDCM_DIR}\", "
        "but this project is using GDCM from \"${GDCM_DIR}\".  "
        "Please set GDCM_DIR to match the one used to build ITK."
        )
    ENDIF(NOT ITK_GDCM_DIR_MATCH)
  ELSE(GDCM_FOUND)
    IF(GDCM_DIR)
      IF(NOT ITK_GDCM_DIR_MATCH)
        MESSAGE(
          "Warning: ITK was built with GDCM from \"${ITK_GDCM_DIR}\", "
          "but this project has set GDCM_DIR to \"${GDCM_DIR}\".  "
          "ITK is changing GDCM_DIR to match the GDCM with which it was built."
          )
      ENDIF(NOT ITK_GDCM_DIR_MATCH)
    ENDIF(GDCM_DIR)
    SET(GDCM_DIR ${ITK_GDCM_DIR})
    FIND_PACKAGE(GDCM)
    IF(GDCM_FOUND)
      INCLUDE(${GDCM_USE_FILE})
    ELSE(GDCM_FOUND)
      MESSAGE(FATAL_ERROR
        "UseITK could not load GDCM settings from \"${GDCM_DIR}\" even through "
        "ITK was built using GDCM from this location."
        )
    ENDIF(GDCM_FOUND)
  ENDIF(GDCM_FOUND)
ENDIF(ITK_USE_SYSTEM_GDCM)
