# Directory containing class headers.
SET(VTK_FILTERING_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.10")

# Classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES
  "vtkImageToStructuredGrid"
  "vtkAbstractCellLocator"
  "vtkAbstractImageInterpolator"
  "vtkAbstractInterpolatedVelocityField"
  "vtkAbstractMapper"
  "vtkAbstractPointLocator"
  "vtkActor2DCollection"
  "vtkActor2D"
  "vtkAdjacentVertexIterator"
  "vtkAlgorithm"
  "vtkAlgorithmOutput"
  "vtkAMRBox"
  "vtkAnnotation"
  "vtkAnnotationLayers"
  "vtkAnnotationLayersAlgorithm"
  "vtkAtom"
  "vtkAttributesErrorMetric"
  "vtkBiQuadraticQuad"
  "vtkBiQuadraticQuadraticHexahedron"
  "vtkBiQuadraticQuadraticWedge"
  "vtkBiQuadraticTriangle"
  "vtkBond"
  "vtkBSPCuts"
  "vtkBSPIntersections"
  "vtkCachedStreamingDemandDrivenPipeline"
  "vtkCardinalSpline"
  "vtkCastToConcrete"
  "vtkCell3D"
  "vtkCellArray"
  "vtkCell"
  "vtkCellData"
  "vtkCellLinks"
  "vtkCellLocator"
  "vtkCellTreeLocator"
  "vtkCellTypes"
  "vtkColorTransferFunction"
  "vtkCompositeDataIterator"
  "vtkCompositeDataPipeline"
  "vtkCompositeDataSetAlgorithm"
  "vtkCompositeDataSet"
  "vtkComputingResources"
  "vtkCone"
  "vtkConvexPointSet"
  "vtkCoordinate"
  "vtkCubicLine"
  "vtkCylinder"
  "vtkDataObjectAlgorithm"
  "vtkDataObjectCollection"
  "vtkDataObject"
  "vtkDataObjectSource"
  "vtkDataObjectTypes"
  "vtkDataSetAlgorithm"
  "vtkDataSetAttributes"
  "vtkDataSetCollection"
  "vtkDataSet"
  "vtkDataSetSource"
  "vtkDataSetToDataSetFilter"
  "vtkDataSetToImageFilter"
  "vtkDataSetToPolyDataFilter"
  "vtkDataSetToStructuredGridFilter"
  "vtkDataSetToStructuredPointsFilter"
  "vtkDataSetToUnstructuredGridFilter"
  "vtkDemandDrivenPipeline"
  "vtkDirectedAcyclicGraph"
  "vtkDirectedGraphAlgorithm"
  "vtkDirectedGraph"
  "vtkDiscretizableColorTransferFunction"
  "vtkDistributedGraphHelper"
  "vtkEdgeListIterator"
  "vtkEmptyCell"
  "vtkExecutionScheduler"
  "vtkExecutionSchedulerManager"
  "vtkExecutive"
  "vtkExecutiveCollection"
  "vtkExplicitCell"
  "vtkFieldData"
  "vtkFilteringInformationKeyManager"
  "vtkGenericAdaptorCell"
  "vtkGenericAttributeCollection"
  "vtkGenericAttribute"
  "vtkGenericCell"
  "vtkGenericCellIterator"
  "vtkGenericCellTessellator"
  "vtkGenericDataSetAlgorithm"
  "vtkGenericDataSet"
  "vtkGenericEdgeTable"
  "vtkGenericInterpolatedVelocityField"
  "vtkGenericPointIterator"
  "vtkGenericSubdivisionErrorMetric"
  "vtkGeometricErrorMetric"
  "vtkGraphAlgorithm"
  "vtkGraph"
  "vtkGraphEdge"
  "vtkGraphInternals"
  "vtkGraphWeightFilter"
  "vtkGraphWeightEuclideanDistanceFilter"
  "vtkHexagonalPrism"
  "vtkHexahedron"
  "vtkHierarchicalBoxDataIterator"
  "vtkHierarchicalBoxDataSetAlgorithm"
  "vtkHierarchicalBoxDataSet"
  "vtkHyperOctreeAlgorithm"
  "vtkHyperOctreeCursor"
  "vtkHyperOctree"
  "vtkHyperOctreePointsGrabber"
  "vtkImageAlgorithm"
  "vtkImageBSplineInternals"
  "vtkImageBSplineInterpolator"
  "vtkImageData"
  "vtkImageInPlaceFilter"
  "vtkImageInterpolator"
  "vtkImageIterator"
  "vtkImageMultipleInputFilter"
  "vtkImageMultipleInputOutputFilter"
  "vtkImageProgressIterator"
  "vtkImageSincInterpolator"
  "vtkImageSource"
  "vtkImageToImageFilter"
  "vtkImageToStructuredPoints"
  "vtkImageTwoInputFilter"
  "vtkImplicitBoolean"
  "vtkImplicitDataSet"
  "vtkImplicitHalo"
  "vtkImplicitSelectionLoop"
  "vtkImplicitSum"
  "vtkImplicitVolume"
  "vtkImplicitWindowFunction"
  "vtkIncrementalOctreeNode"
  "vtkIncrementalOctreePointLocator"
  "vtkIncrementalPointLocator"
  "vtkInEdgeIterator"
  "vtkInformation"
  "vtkInformationExecutivePortKey"
  "vtkInformationExecutivePortVectorKey"
  "vtkInterpolatedVelocityField"
  "vtkKdNode"
  "vtkKdTree"
  "vtkKdTreePointLocator"
  "vtkKochanekSpline"
  "vtkLine"
  "vtkLinearSelector"
  "vtkLocator"
  "vtkMapper2D"
  "vtkMeanValueCoordinatesInterpolator"
  "vtkMergePoints"
  "vtkMarchingSquaresLineCases"
  "vtkMarchingCubesTriangleCases"
  "vtkMolecule"
  "vtkMultiBlockDataSetAlgorithm"
  "vtkMultiBlockDataSet"
  "vtkMultiPieceDataSet"
  "vtkMutableDirectedGraph"
  "vtkMutableUndirectedGraph"
  "vtkNonLinearCell"
  "vtkNonMergingPointLocator"
  "vtkOctreePointLocator"
  "vtkOctreePointLocatorNode"
  "vtkOrderedTriangulator"
  "vtkOutEdgeIterator"
  "vtkParametricSpline"
  "vtkPassInputTypeAlgorithm"
  "vtkPentagonalPrism"
  "vtkPerlinNoise"
  "vtkPiecewiseFunctionAlgorithm"
  "vtkPiecewiseFunction"
  "vtkPiecewiseFunctionShiftScale"
  "vtkPixel"
  "vtkPlanesIntersection"
  "vtkPointData"
  "vtkPointLocator"
  "vtkPointSetAlgorithm"
  "vtkPointSet"
  "vtkPointSetSource"
  "vtkPointSetToPointSetFilter"
  "vtkPointsProjectedHull"
  "vtkPolyDataAlgorithm"
  "vtkPolyDataCollection"
  "vtkPolyData"
  "vtkPolyDataSource"
  "vtkPolyDataToPolyDataFilter"
  "vtkPolygon"
  "vtkPolyhedron"
  "vtkPolyLine"
  "vtkPolyPlane"
  "vtkPolyVertex"
  "vtkProcessObject"
  "vtkPropAssembly"
  "vtkPyramid"
  "vtkQuad"
  "vtkQuadraticEdge"
  "vtkQuadraticHexahedron"
  "vtkQuadraticLinearQuad"
  "vtkQuadraticLinearWedge"
  "vtkQuadraticPyramid"
  "vtkQuadraticQuad"
  "vtkQuadraticTetra"
  "vtkQuadraticTriangle"
  "vtkQuadraticWedge"
  "vtkRectilinearGridAlgorithm"
  "vtkRectilinearGrid"
  "vtkRectilinearGridSource"
  "vtkRectilinearGridToPolyDataFilter"
  "vtkReebGraph"
  "vtkReebGraphSimplificationMetric"
  "vtkScalarTree"
  "vtkSelectionAlgorithm"
  "vtkSelection"
  "vtkSelectionNode"
  "vtkSimpleCellTessellator"
  "vtkSimpleImageToImageFilter"
  "vtkSimpleScalarTree"
  "vtkSmoothErrorMetric"
  "vtkSource"
  "vtkSphere"
  "vtkSpline"
  "vtkStreamingDemandDrivenPipeline"
  "vtkStructuredGridAlgorithm"
  "vtkStructuredGrid"
  "vtkStructuredGridSource"
  "vtkStructuredGridToPolyDataFilter"
  "vtkStructuredGridToStructuredGridFilter"
  "vtkStructuredPointsCollection"
  "vtkStructuredPoints"
  "vtkStructuredPointsSource"
  "vtkStructuredPointsToPolyDataFilter"
  "vtkStructuredPointsToStructuredPointsFilter"
  "vtkStructuredPointsToUnstructuredGridFilter"
  "vtkSuperquadric"
  "vtkTableAlgorithm"
  "vtkTable"
  "vtkTemporalDataSetAlgorithm"
  "vtkTemporalDataSet"
  "vtkTetra"
  "vtkThreadedImageAlgorithm"
  "vtkThreadedStreamingPipeline"
  "vtkTreeAlgorithm"
  "vtkTree"
  "vtkTreeBFSIterator"
  "vtkTreeDFSIterator"
  "vtkTreeIterator"
  "vtkTriangle"
  "vtkTriangleStrip"
  "vtkTriQuadraticHexahedron"
  "vtkTrivialProducer"
  "vtkUndirectedGraphAlgorithm"
  "vtkUndirectedGraph"
  "vtkUniformGrid"
  "vtkUnstructuredGridAlgorithm"
  "vtkUnstructuredGrid"
  "vtkUnstructuredGridSource"
  "vtkUnstructuredGridToPolyDataFilter"
  "vtkUnstructuredGridToUnstructuredGridFilter"
  "vtkVertex"
  "vtkVertexListIterator"
  "vtkViewDependentErrorMetric"
  "vtkViewport"
  "vtkVoxel"
  "vtkWedge"
  "vtkArrayData"
  "vtkArrayDataAlgorithm")

# Abstract classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_ABSTRACT
  "vtkAbstractCellLocator"
  "vtkAbstractImageInterpolator"
  "vtkAbstractInterpolatedVelocityField"
  "vtkAbstractMapper"
  "vtkAbstractPointLocator"
  "vtkCell3D"
  "vtkCell"
  "vtkCompositeDataIterator"
  "vtkCompositeDataSet"
  "vtkDataObjectSource"
  "vtkDataSet"
  "vtkDataSetSource"
  "vtkDataSetToDataSetFilter"
  "vtkDataSetToImageFilter"
  "vtkDataSetToPolyDataFilter"
  "vtkDataSetToStructuredGridFilter"
  "vtkDataSetToStructuredPointsFilter"
  "vtkDataSetToUnstructuredGridFilter"
  "vtkDistributedGraphHelper"
  "vtkExecutive"
  "vtkExplicitCell"
  "vtkFilteringInformationKeyManager"
  "vtkGenericAdaptorCell"
  "vtkGenericAttribute"
  "vtkGenericCellIterator"
  "vtkGenericCellTessellator"
  "vtkGenericDataSetAlgorithm"
  "vtkGenericDataSet"
  "vtkGenericPointIterator"
  "vtkGenericSubdivisionErrorMetric"
  "vtkGraph"
  "vtkGraphWeightFilter"
  "vtkHyperOctreeAlgorithm"
  "vtkHyperOctreeCursor"
  "vtkHyperOctreePointsGrabber"
  "vtkImageAlgorithm"
  "vtkImageInPlaceFilter"
  "vtkImageIterator"
  "vtkImageMultipleInputFilter"
  "vtkImageMultipleInputOutputFilter"
  "vtkImageProgressIterator"
  "vtkImageSource"
  "vtkImageToImageFilter"
  "vtkImageTwoInputFilter"
  "vtkIncrementalPointLocator"
  "vtkInformationExecutivePortKey"
  "vtkInformationExecutivePortVectorKey"
  "vtkLocator"
  "vtkMapper2D"
  "vtkNonLinearCell"
  "vtkPointSet"
  "vtkPointSetSource"
  "vtkPointSetToPointSetFilter"
  "vtkPolyDataSource"
  "vtkPolyDataToPolyDataFilter"
  "vtkProcessObject"
  "vtkRectilinearGridSource"
  "vtkRectilinearGridToPolyDataFilter"
  "vtkScalarTree"
  "vtkSimpleImageToImageFilter"
  "vtkSource"
  "vtkSpline"
  "vtkStructuredGridSource"
  "vtkStructuredGridToPolyDataFilter"
  "vtkStructuredGridToStructuredGridFilter"
  "vtkStructuredPointsSource"
  "vtkStructuredPointsToPolyDataFilter"
  "vtkStructuredPointsToStructuredPointsFilter"
  "vtkStructuredPointsToUnstructuredGridFilter"
  "vtkThreadedImageAlgorithm"
  "vtkTreeIterator"
  "vtkUnstructuredGridSource"
  "vtkUnstructuredGridToPolyDataFilter"
  "vtkUnstructuredGridToUnstructuredGridFilter"
  "vtkViewport")

# Wrap-exclude classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_WRAP_EXCLUDE
  "vtkAMRBox"
  "vtkAtom"
  "vtkBond"
  "vtkExecutionSchedulerManager"
  "vtkFilteringInformationKeyManager"
  "vtkImageBSplineInternals"
  "vtkImageIterator"
  "vtkImageProgressIterator"
  "vtkInformation"
  "vtkMarchingSquaresLineCases"
  "vtkMarchingCubesTriangleCases")

# Wrap-special classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_WRAP_SPECIAL
  "vtkAtom"
  "vtkBond"
  "vtkImageBSplineInternals")

# Wrappable non-class headers for vtkFiltering.
SET(VTK_FILTERING_WRAP_HEADERS
  "vtkCellType.h")

# Set convenient variables to test each class.
FOREACH(class ${VTK_FILTERING_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_WRAP_SPECIAL})
  SET(VTK_CLASS_WRAP_SPECIAL_${class} 1)
ENDFOREACH(class)
