
#ifndef __CREA__IMAGE_H_INCLUDED__
#define __CREA__IMAGE_H_INCLUDED__

#include "vtkTransform.h"
#include "vtkImageData.h"
#include "matrixRotation.h"

class CreaImage
{
public:
	CreaImage();
	~CreaImage();
	void SetvtkImageData(vtkImageData *image);
	void SetImagePositionPatient(double x,double y,double z);
	void SetImageSpacing(double sx, double sy, double sz);
	void SetImageOrientation(double v1x,double v1y,double v1z, double v2x,double v2y,double v2z);
	void Update();
	vtkImageData *GetImage();
	vtkTransform *GetvtkTransform();
	double GetVoxelInIRMUniverse(double x,double y, double z);		
	double GetVoxelInImageUniverse(double x,double y, double z);		

private:
  vtkImageData 		*orgImage;
  matrixRotation 	*matrixrotation;
  vtkTransform 		*transform;

protected:

}; 

#endif // __CREA__IMAGE_H_INCLUDED__
