/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageResampleBox_h_INCLUDED__
#define __bbPackRecalageResampleBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include <vtkVersionMacros.h>
#include "vtkImageResample.h"
#include "vtkImageData.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ResampleBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ResampleBox, bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData *);
  BBTK_DECLARE_INPUT(Factor,double);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData *);
  BBTK_PROCESS(Process);
  void Process();

  vtkImageResample *resample;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ResampleBox,bbtk::AtomicBlackBox);
BBTK_NAME("ResampleBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Does resampling of an image, creating a copy of the original image with different extent and spacing");
BBTK_CATEGORY("filter");
BBTK_INPUT(ResampleBox,In,"Original image",vtkImageData *,"");
BBTK_INPUT(ResampleBox,Factor,"Resampling factor",double,"");
BBTK_OUTPUT(ResampleBox,Out,"Resampled image",vtkImageData *,"");
BBTK_END_DESCRIBE_BLACK_BOX(ResampleBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageResampleBox_h_INCLUDED__

