/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageTransform2DBox_h_INCLUDED__
#define __bbPackRecalageTransform2DBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkLinearTransform.h"
#include "Transformer.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT Transform2DBox
 : 
   public bbtk::AtomicBlackBox
{
		BBTK_BLACK_BOX_INTERFACE(Transform2DBox,bbtk::AtomicBlackBox);
		/*Point(x,y) -> Rotation Center*/
		BBTK_DECLARE_INPUT(CenterPoint,std::vector<int>);

		/*Rotation angle*/
		BBTK_DECLARE_INPUT(Angle,double);

		
		/*Scalation to be done in the x axis*/
		BBTK_DECLARE_INPUT(ScaleX,double);

		
		/*Scalation to be done in the y axis*/
		BBTK_DECLARE_INPUT(ScaleY,double);

		/*Scalation to be done in the z axis*/
		BBTK_DECLARE_INPUT(ScaleZ,double);

		/*Resultant vtkTransform*/
		BBTK_DECLARE_OUTPUT(Out, vtkTransform*);

		BBTK_PROCESS(Process);
		void Process();
		
		/*Class in charge of making the transformations*/
		Transformer *transformer;		
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Transform2DBox,bbtk::AtomicBlackBox);
BBTK_NAME("Transform2DBox");
BBTK_AUTHOR("va-perez@uniandes.edu.co");
BBTK_DESCRIPTION("Given 2 points and an angle, it calculates the vtkTransform result after aplying the transformations, using the first point as base of the transformation");
BBTK_CATEGORY("filter");
BBTK_INPUT(Transform2DBox,CenterPoint,"Point (x,y,z) -> Rotation Center",std::vector<int>,"");
BBTK_INPUT(Transform2DBox,Angle,"Rotation Angle",double,"");
BBTK_INPUT(Transform2DBox,ScaleX,"Scale in X",double,"");
BBTK_INPUT(Transform2DBox,ScaleY,"Scale in Y",double,"");
BBTK_INPUT(Transform2DBox,ScaleZ,"Scale in Z",double,"");
BBTK_OUTPUT(Transform2DBox,Out,"Linear Transform filter",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(Transform2DBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageTransform2DBox_h_INCLUDED__

