/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageTransparencyV2_h_INCLUDED__
#define __bbPackRecalageTransparencyV2_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"
#include "Transparency.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT TransparencyBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TransparencyBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(Percent,int);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  Transparency *transparency;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TransparencyBox,bbtk::AtomicBlackBox);
BBTK_NAME("TransparencyBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Transparency between two images");
BBTK_CATEGORY("filter");
BBTK_INPUT(TransparencyBox,In1,"First image for transparency",vtkImageData*,"");
BBTK_INPUT(TransparencyBox,In2,"Second image for transparency",vtkImageData*,"");
BBTK_INPUT(TransparencyBox,Percent,"Percent of transparency for the second image",int,"");
BBTK_OUTPUT(TransparencyBox,Out,"Output Image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(TransparencyBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageTransparencyV2_h_INCLUDED__

