#ifndef __bbTransform3DdicomCreateComplementImage_h_INCLUDED__
#define __bbTransform3DdicomCreateComplementImage_h_INCLUDED__
#include "bbTransform3Ddicom_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"

#include "CreaImage.h"
#include "CreaImageComplement.h"


namespace bbTransform3Ddicom
{

class bbTransform3Ddicom_EXPORT CreateComplementImage
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(CreateComplementImage,bbtk::AtomicBlackBox);
//==================================================================

/*
/// User callback called in the box contructor
virtual void bbUserConstructor();
/// User callback called in the box copy constructor
virtual void bbUserCopyConstructor(bbtk::BlackBox::Pointer);
/// User callback called in the box destructor
virtual void bbUserDestructor();
*/

//==================================================================

  BBTK_DECLARE_INPUT(Image1, vtkImageData* );
  BBTK_DECLARE_INPUT(Image2, vtkImageData* );
  BBTK_DECLARE_INPUT(ExtOut,std::vector<double> );
  BBTK_DECLARE_INPUT(SpcOut,std::vector<double> );
  BBTK_DECLARE_INPUT(Spacing1,std::vector<double> );
  BBTK_DECLARE_INPUT(Spacing2,std::vector<double> );
  BBTK_DECLARE_INPUT(Position1,std::vector<double> );
  BBTK_DECLARE_INPUT(Position2,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation1Vec1,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation1Vec2,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation2Vec1,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation2Vec2,std::vector<double> );
  BBTK_DECLARE_OUTPUT(Out, vtkImageData* );
  BBTK_DECLARE_OUTPUT(Out2, vtkImageData* );

  BBTK_PROCESS(Process);
  void Process();

	CreaImage			*creaimage1;
	CreaImage			*creaimage2;
	CreaImageComplement *creaimagecomplement;
	vtkImageData		*imageresult;
	vtkImageData		*imageresult2;


};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CreateComplementImage,bbtk::AtomicBlackBox);
BBTK_NAME("CreateComplementImage");
BBTK_AUTHOR("InfoTeam");
BBTK_DESCRIPTION("_description_");
BBTK_CATEGORY("");

BBTK_INPUT(CreateComplementImage,Image1,"Input image 1", vtkImageData* ,"");
BBTK_INPUT(CreateComplementImage,Image2,"Input image 2", vtkImageData* ,"");
BBTK_INPUT(CreateComplementImage,ExtOut,"Extend output image", std::vector<double> ,"");
BBTK_INPUT(CreateComplementImage,SpcOut,"Spacing output image", std::vector<double> ,"");
BBTK_INPUT(CreateComplementImage,Spacing1,"Spacing image 1",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Spacing2,"Spacing image 2",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Position1,"Position image 1",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Position2,"Position image 2",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Orientation1Vec1,"Orientation image 1 with vec 1",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Orientation1Vec2,"Orientation image 1 with vec 2",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Orientation2Vec1,"Orientation image 2 with vec 1",std::vector<double>,"");
BBTK_INPUT(CreateComplementImage,Orientation2Vec2,"Orientation image 2 with vec 2",std::vector<double>,"");
BBTK_OUTPUT(CreateComplementImage,Out,"Output image",vtkImageData*,"");
BBTK_OUTPUT(CreateComplementImage,Out2,"Output image",vtkImageData*,"");


BBTK_END_DESCRIBE_BLACK_BOX(CreateComplementImage);
}
// EO namespace bbTransform3Ddicom

#endif // __bbTransform3DdicomCreateComplementImage_h_INCLUDED__

