#ifndef __bbTransform3DdicomMetaImageReader_DicomInfo_h_INCLUDED__
#define __bbTransform3DdicomMetaImageReader_DicomInfo_h_INCLUDED__
#include "bbTransform3Ddicom_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

namespace bbTransform3Ddicom
{

class bbTransform3Ddicom_EXPORT MetaImageReader_DicomInfo
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(MetaImageReader_DicomInfo,bbtk::AtomicBlackBox);
//==================================================================

/*
/// User callback called in the box contructor
virtual void bbUserConstructor();
/// User callback called in the box copy constructor
virtual void bbUserCopyConstructor(bbtk::BlackBox::Pointer);
/// User callback called in the box destructor
virtual void bbUserDestructor();
*/

//==================================================================
  BBTK_DECLARE_INPUT( In , std::string );
	BBTK_DECLARE_OUTPUT(IPP, std::vector<double> );
	BBTK_DECLARE_OUTPUT(IOP, std::vector<double> );
	BBTK_DECLARE_OUTPUT(PixelSpacing, std::vector<double> );
  BBTK_PROCESS(Process);
  void Process();
	std::vector<double>  IPP;
	std::vector<double>  IOP;
	std::vector<double>  PixelSpacing;
	
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(MetaImageReader_DicomInfo,bbtk::AtomicBlackBox);
BBTK_NAME("MetaImageReader_DicomInfo");
BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Read MHD and MHD_dicominfo");
BBTK_CATEGORY("");
	BBTK_INPUT(MetaImageReader_DicomInfo,In,"File name", std::string ,"");
    BBTK_OUTPUT(MetaImageReader_DicomInfo,IPP,"Image position patient", std::vector<double>,"");
    BBTK_OUTPUT(MetaImageReader_DicomInfo,IOP,"Image orientation patient", std::vector<double>,"");
    BBTK_OUTPUT(MetaImageReader_DicomInfo,PixelSpacing,"Spacing ", std::vector<double>,"");
BBTK_END_DESCRIBE_BLACK_BOX(MetaImageReader_DicomInfo);
}
// EO namespace bbTransform3Ddicom

#endif // __bbTransform3DdicomMetaImageReader_DicomInfo_h_INCLUDED__

