#ifndef __bbTransform3DdicomMetaImageWriter_DicomInfo_h_INCLUDED__
#define __bbTransform3DdicomMetaImageWriter_DicomInfo_h_INCLUDED__
#include "bbTransform3Ddicom_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

namespace bbTransform3Ddicom
{

class bbTransform3Ddicom_EXPORT MetaImageWriter_DicomInfo
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(MetaImageWriter_DicomInfo,bbtk::AtomicBlackBox);
//==================================================================
/*
/// User callback called in the box contructor
virtual void bbUserConstructor();
/// User callback called in the box copy constructor
virtual void bbUserCopyConstructor(bbtk::BlackBox::Pointer);
/// User callback called in the box destructor
virtual void bbUserDestructor();
*/
//==================================================================
  BBTK_DECLARE_INPUT( Filename, std::string );
  BBTK_DECLARE_INPUT( PixelSpacing,std::vector<double> );
  BBTK_DECLARE_INPUT( IPP,std::vector<double> );
  BBTK_DECLARE_INPUT( IOP,std::vector<double> );
//  BTK_DECLARE_OUTPUT(Out,double);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(MetaImageWriter_DicomInfo,bbtk::AtomicBlackBox);
BBTK_NAME("MetaImageWriter_DicomInfo");
BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Write MHD and MHD_dicominfo");
BBTK_CATEGORY("");
BBTK_INPUT(MetaImageWriter_DicomInfo,Filename,"File name",std::string,"");
BBTK_INPUT(MetaImageWriter_DicomInfo,PixelSpacing,"Pixel Spacing",std::vector<double>,"");
BBTK_INPUT(MetaImageWriter_DicomInfo,IPP,"Image position patient",std::vector<double>,"");
BBTK_INPUT(MetaImageWriter_DicomInfo,IOP,"Image orientation patient",std::vector<double>,"");
//BBTK_OUTPUT(MetaImageWriter_DicomInfo,Out,"First output",double,"");
BBTK_END_DESCRIBE_BLACK_BOX(MetaImageWriter_DicomInfo);
}
// EO namespace bbTransform3Ddicom

#endif // __bbTransform3DdicomMetaImageWriter_DicomInfo_h_INCLUDED__

