#ifndef __bbTransform3DdicomNewDicomImaPosPat_h_INCLUDED__
#define __bbTransform3DdicomNewDicomImaPosPat_h_INCLUDED__
#include "bbTransform3Ddicom_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "vtkLinearTransform.h"

namespace bbTransform3Ddicom
{

class bbTransform3Ddicom_EXPORT NewDicomImaPosPat
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(NewDicomImaPosPat,bbtk::AtomicBlackBox);

/*
//==================================================================
/// User callback called in the box contructor
virtual void bbUserConstructor();
/// User callback called in the box copy constructor
virtual void bbUserCopyConstructor(bbtk::BlackBox::Pointer);
/// User callback called in the box destructor
virtual void bbUserDestructor();
//==================================================================
*/

	BBTK_DECLARE_INPUT( Point,std::vector<double> );
	BBTK_DECLARE_INPUT( IPP,std::vector<double> );
	BBTK_DECLARE_INPUT( IOP,std::vector<double> );
	BBTK_DECLARE_INPUT( PixelSpacing,std::vector<double> );
	BBTK_DECLARE_OUTPUT( Out, std::vector<double> );
	BBTK_DECLARE_OUTPUT( Transform, vtkLinearTransform* );
	BBTK_PROCESS(Process);
  void Process();

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(NewDicomImaPosPat,bbtk::AtomicBlackBox);
  BBTK_NAME("NewDicomImaPosPat");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("New Dicom ImagePositionPatient");
  BBTK_CATEGORY("");
	
  BBTK_INPUT(NewDicomImaPosPat,Point,"point to be transform", std::vector<double> ,"");
  BBTK_INPUT(NewDicomImaPosPat,IPP,"Image Position Patient",std::vector<double>,"");
  BBTK_INPUT(NewDicomImaPosPat,IOP,"Image Orientation Patient",std::vector<double>,"");
  BBTK_INPUT(NewDicomImaPosPat,PixelSpacing,"Pixel Spacing",std::vector<double>,"");

  BBTK_OUTPUT(NewDicomImaPosPat,Out , "New Image Position Patient" , std::vector<double> , "");
  BBTK_OUTPUT(NewDicomImaPosPat,Transform,"Linear Transform (4x4 homogeneous)",vtkLinearTransform*,"");
	
BBTK_END_DESCRIBE_BLACK_BOX(NewDicomImaPosPat);
}
// EO namespace bbTransform3Ddicom

#endif // __bbTransform3DdicomNewDicomImaPosPat_h_INCLUDED__

