#ifndef __bbTransform3DdicomRotateDICOM_h_INCLUDED__
#define __bbTransform3DdicomRotateDICOM_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkLinearTransform.h>


namespace bbTransform3Ddicom
{

class /*BBTK_EXPORT*/ RotateDICOM
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(RotateDICOM,bbtk::AtomicBlackBox);

/*
//==================================================================
/// User callback called in the box contructor
virtual void bbUserConstructor();
/// User callback called in the box copy constructor
virtual void bbUserCopyConstructor(bbtk::BlackBox::Pointer);
/// User callback called in the box destructor
virtual void bbUserDestructor();
//==================================================================
*/

  BBTK_DECLARE_INPUT(Spacing1,std::vector<double> );
  BBTK_DECLARE_INPUT(Spacing2,std::vector<double> );
  BBTK_DECLARE_INPUT(Position1,std::vector<double> );
  BBTK_DECLARE_INPUT(Position2,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation1Vec12,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation1Vec1,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation1Vec2,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation2Vec12,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation2Vec1,std::vector<double> );
  BBTK_DECLARE_INPUT(Orientation2Vec2,std::vector<double> );
  BBTK_DECLARE_OUTPUT(Out, vtkLinearTransform * );
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(RotateDICOM,bbtk::AtomicBlackBox);
BBTK_NAME("RotateDICOM");
BBTK_AUTHOR("InfoTeam CREATIS-LRMN");
BBTK_DESCRIPTION("Transform 4x4 matix");
BBTK_CATEGORY("filter");

BBTK_INPUT(RotateDICOM,Spacing1,"Spacing image 1",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Spacing2,"Spacing image 2",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Position1,"Position image 1",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Position2,"Position image 2",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Orientation1Vec1,"Orientation image 1 with vec 1",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Orientation1Vec12,"Orientation image 1 with vec 1 and 2 [x1 y1 z1 x2 y2 z2]",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Orientation1Vec2,"Orientation image 1 with vec 2",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Orientation2Vec12,"Orientation image 2 with vec 1 and 2 [x1 y1 z1 x2 y2 z2]",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Orientation2Vec1,"Orientation image 2 with vec 1",std::vector<double>,"");
BBTK_INPUT(RotateDICOM,Orientation2Vec2,"Orientation image 2 with vec 2",std::vector<double>,"");
BBTK_OUTPUT(RotateDICOM,Out,"Linear Transform (4x4 homogeneous)",vtkLinearTransform*,"");



BBTK_END_DESCRIBE_BLACK_BOX(RotateDICOM);
}
// EO namespace bbTransform3Ddicom

#endif // __bbTransform3DdicomRotateDICOM_h_INCLUDED__

