#ifndef __bbTransform3DdicomTransformSimple_h_INCLUDED__
#define __bbTransform3DdicomTransformSimple_h_INCLUDED__
#include "bbTransform3Ddicom_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkLinearTransform.h>
#include <vtkTransform.h>
#include <vtkImageData.h>
#include "CreaImage.h"


namespace bbTransform3Ddicom
{

class bbTransform3Ddicom_EXPORT TransformSimple
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TransformSimple,bbtk::AtomicBlackBox);
/*
//==================================================================
/// User callback called in the box contructor
virtual void bbUserConstructor();
/// User callback called in the box copy constructor
virtual void bbUserCopyConstructor(bbtk::BlackBox::Pointer);
/// User callback called in the box destructor
virtual void bbUserDestructor();
//==================================================================
*/

  BBTK_DECLARE_INPUT( InImage, vtkImageData* );
  BBTK_DECLARE_INPUT( PixelSpacing,std::vector<double> );
  BBTK_DECLARE_INPUT( IPP,std::vector<double> );
  BBTK_DECLARE_INPUT( IOP,std::vector<double> );
  BBTK_DECLARE_OUTPUT( Out, vtkLinearTransform* );
  BBTK_DECLARE_OUTPUT( OutImage, vtkImageData* );
  BBTK_PROCESS(Process);
  void Process();

  CreaImage *creaimage;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TransformSimple,bbtk::AtomicBlackBox);
  BBTK_NAME("TransformSimple"); 
  BBTK_AUTHOR("InfoTeam CREATIS-LRMN");
  BBTK_DESCRIPTION("Transofrm matrix to ConsoleWindow");
  BBTK_CATEGORY("");

  BBTK_INPUT(TransformSimple,InImage,"Input image ", vtkImageData* ,"");
  BBTK_INPUT(TransformSimple,PixelSpacing,"Spacing image ",std::vector<double>,"");
  BBTK_INPUT(TransformSimple,IPP,"Position image ",std::vector<double>,"");
  BBTK_INPUT(TransformSimple,IOP,"Orientation image  with vec 1",std::vector<double>,"");
  
  BBTK_OUTPUT(TransformSimple,Out,"Linear Transform (4x4 homogeneous)",vtkLinearTransform*,"");
  BBTK_OUTPUT(TransformSimple,OutImage,"Output image", vtkImageData*,"");

BBTK_END_DESCRIBE_BLACK_BOX(TransformSimple);
}
// EO namespace bbTransform3Ddicom

#endif // __bbTransform3DdicomTransformSimple_h_INCLUDED__

