/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#ifndef __bbcreaImageIOItkImagesChooserDialogBox_h_INCLUDED__
#define __bbcreaImageIOItkImagesChooserDialogBox_h_INCLUDED__

#define BBTK_ITK_IMAGE_DIM_2
#define BBTK_ITK_IMAGE_DIM_3
#define BBTK_ITK_IMAGE_DIM_4
#define BBTK_ITK_IMAGE_TYPE_int8_t
#define BBTK_ITK_IMAGE_TYPE_uint8_t
#define BBTK_ITK_IMAGE_TYPE_int16_t
#define BBTK_ITK_IMAGE_TYPE_uint16_t
#define BBTK_ITK_IMAGE_TYPE_int32_t
#define BBTK_ITK_IMAGE_TYPE_uint32_t
#define BBTK_ITK_IMAGE_TYPE_float
#define BBTK_ITK_IMAGE_TYPE_double

#include "bbcreaImageIO_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"
#include "bbtkAny.h"
#include "creaImageIOWxAnySimpleDlg.h"

namespace bbcreaImageIO
{
typedef std::vector<vtkImageData*> OutputImagesVTKType;
typedef std::vector<bbitk::anyImagePointer> OutputImagesITKType;

class bbcreaImageIO_EXPORT ItkImagesChooserDialogBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ItkImagesChooserDialogBox,bbtk::AtomicBlackBox);
 
  
	creaImageIO::WxAnySimpleDlg *dlg;
	 

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
  BBTK_DECLARE_INPUT(Title,std::string);
  BBTK_DECLARE_OUTPUT(OutVImages,OutputImagesVTKType);
  BBTK_DECLARE_OUTPUT(OutIImages,OutputImagesITKType);
  BBTK_DECLARE_OUTPUT(Out,bbitk::anyImagePointer);
  BBTK_PROCESS(Process);
  void Process();

    private:
    // Template read method 

//EED    template<class TImage> void Export();
template <typename  ty, size_t di> void Export();

	// Template export vtk Images
	template<class TImage> void ExportVTK();

	itk::Object* mOutput;
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ItkImagesChooserDialogBox,bbtk::AtomicBlackBox);

  BBTK_NAME("ItkImagesChooserDialogBox");
  BBTK_AUTHOR("cervenansky.frederic@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("ImagesChooserDialogBox is a simple application to select file(s) or directory or data from Gimmick database, handle them as ITKImage and/or display them. It handles Analayze, DICOM, jpg, tif, png, bmp and mhd.");
  BBTK_CATEGORY("image;reader;dicom;");

  BBTK_INPUT(ItkImagesChooserDialogBox,Title,"Title of the dialog",std::string,"");
  BBTK_OUTPUT(ItkImagesChooserDialogBox,OutVImages,"The selected Vtkimage",OutputImagesVTKType,"");
  BBTK_OUTPUT(ItkImagesChooserDialogBox,Out,"Output Image",bbitk::anyImagePointer,"");
  BBTK_OUTPUT(ItkImagesChooserDialogBox,OutIImages,"Vector of selected images",OutputImagesITKType,"");

BBTK_END_DESCRIBE_BLACK_BOX(ItkImagesChooserDialogBox);

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
}
// EO namespace bbcreaImageIO

#endif // __bbcreaImageIOItkImagesChooserDialogBox_h_INCLUDED__

