/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuRenderingViewer_h_INCLUDED__
#define __bbcreaMaracasVisuRenderingViewer_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkWxBlackBox.h"

#include "vtkImageData.h"
#include "vtkProp3D.h"
#include "vtkRenderer.h"
#include "wxVtkBaseView.h"

namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT RenderingViewer
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(RenderingViewer,bbtk::WxBlackBox);
  //BBTK_DECLARE_INPUT(Title,std::string); 
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_INPUT(wxVtkBaseView,wxVtkBaseView*);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(In3,vtkImageData*);
  BBTK_DECLARE_INPUT(In4,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out1,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out2,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out3,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out4,vtkImageData*);
  BBTK_DECLARE_OUTPUT(ImageFiles, std::vector<std::string>);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

  private:
	vtkRenderer* _currentrenderer;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(RenderingViewer,bbtk::WxBlackBox);
BBTK_NAME("RenderingViewer");
BBTK_AUTHOR("Carolina Perez");
BBTK_DESCRIPTION("Complex box which gathers VolumeRendering and SurfaceRendering funtionalities");
BBTK_CATEGORY("actor");
//BBTK_INPUT(RenderingViewer,Title,"Title prepended to the text",std::string,"");
BBTK_INPUT(RenderingViewer,Renderer,"Renderer to show volume rendering image" ,vtkRenderer*, "");
BBTK_INPUT(RenderingViewer,wxVtkBaseView,"wxVtkBaseView",wxVtkBaseView*,"");
//BBTK_INPUT(RenderingViewer,RendererSA,"Renderer to show surface rendering image" ,vtkRenderer*, "");
//BBTK_INPUT(RenderingViewer,RendererSB,"Renderer to show surface rendering image" ,vtkRenderer*, "");
//BBTK_INPUT(RenderingViewer,RendererSC,"Renderer to show surface rendering image" ,vtkRenderer*, "");
BBTK_INPUT(RenderingViewer,In1,"Input image to the Rendering",vtkImageData*,"");
BBTK_INPUT(RenderingViewer,In2,"Input image to the Rendering",vtkImageData*,"");
BBTK_INPUT(RenderingViewer,In3,"Input image to the Rendering",vtkImageData*,"");
BBTK_INPUT(RenderingViewer,In4,"Input image to the Rendering",vtkImageData*,"");
BBTK_OUTPUT(RenderingViewer,Out1,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(RenderingViewer,Out2,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(RenderingViewer,Out3,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(RenderingViewer,Out4,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(RenderingViewer,ImageFiles,"File Name", std::vector<std::string>,"");
BBTK_END_DESCRIBE_BLACK_BOX(RenderingViewer);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuRenderingViewer_h_INCLUDED__
#endif // _USE_WXWIDGETS_

