/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuSliceImage_h_INCLUDED__
#define __bbcreaMaracasVisuSliceImage_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkVersionMacros.h>
#include <vtkImageData.h>
#include <vtkImageReslice.h>

namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT SliceImage
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(SliceImage,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Z, double );
  BBTK_DECLARE_INPUT(Slice, double );
  BBTK_DECLARE_INPUT(AxisOrigin, std::vector<double> );
  BBTK_DECLARE_INPUT(InterpolationMode,int);
  BBTK_DECLARE_INPUT(TypeOrientation, int );
  BBTK_DECLARE_INPUT(ResliceAxesDirectionCosines, std::vector<double> );
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
	
	vtkImageReslice *imageReslice;
	
};


BBTK_BEGIN_DESCRIBE_BLACK_BOX(SliceImage,bbtk::AtomicBlackBox);
  BBTK_NAME("SliceImage");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("filter");
  BBTK_CATEGORY("");

  BBTK_INPUT(SliceImage,In,"Input image",vtkImageData *,"");
  BBTK_INPUT(SliceImage,Slice,"Slice",double,"");
  BBTK_INPUT(SliceImage,AxisOrigin,"Axis origin [px py pz] ",std::vector<double>,"");
  BBTK_INPUT(SliceImage,Z,"Z (deprecated)",double,"");
  BBTK_INPUT(SliceImage,InterpolationMode,"(default 0) 0=NearestNeighbor  1=Linear  2=Cubic",int,"");
  BBTK_INPUT(SliceImage,ResliceAxesDirectionCosines,"ResliceAxesDirectionCosines [v1x,v1y,v1z,v2x,v2y,v2z,v3x,v3y,v3z],  ",std::vector<double>,"");
  BBTK_INPUT(SliceImage,TypeOrientation,"Type orientation (default 0) 0=XY, 1=X-Z, -1=XZ, 2=Y-Z, -2=ZY, 3=Free (Set the input ResliceAxesDirectionCosines)",int,"");

  BBTK_OUTPUT(SliceImage,Out,"Output image",vtkImageData *,"");

BBTK_END_DESCRIBE_BLACK_BOX(SliceImage);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuSliceImage_h_INCLUDED__

