/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuSurfaceRendering_h_INCLUDED__
#define __bbcreaMaracasVisuSurfaceRendering_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkWxBlackBox.h"
#include "vtkRenderWindowInteractor.h"

#include "vtkImageData.h"
#include "vtkProp3D.h"

//#include "marInterface.h"

namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT SurfaceRendering
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(SurfaceRendering,bbtk::WxBlackBox);
  //BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_INPUT(Interactor,vtkRenderWindowInteractor*);
  BBTK_DECLARE_INPUT(In0,vtkImageData*);  
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(In3,vtkImageData*);
  BBTK_DECLARE_INPUT(In4,vtkImageData*);

  BBTK_DECLARE_OUTPUT(Out1,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out2,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out3,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out4,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	//marInterface* mar;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(SurfaceRendering,bbtk::WxBlackBox);
BBTK_NAME("SurfaceRendering");
BBTK_AUTHOR("car-prie@uniandes.edu.co");
BBTK_DESCRIPTION("Black Box of the module SurfaceRendering");
BBTK_CATEGORY("actor");
//BBTK_INPUT(SurfaceRendering,In,"Renderer to show the different prop3D",vtkImageData*,"");
BBTK_INPUT(SurfaceRendering,Renderer,"Renderer to show the different prop3D",vtkRenderer*,"");
BBTK_INPUT(SurfaceRendering,Interactor,"Renderer to show the different prop3D",vtkRenderWindowInteractor*,"");
BBTK_INPUT(SurfaceRendering,In0,"Input image to the SurfaceRendering",vtkImageData*,"");
BBTK_INPUT(SurfaceRendering,In1,"Input image to the SurfaceRendering",vtkImageData*,"");
BBTK_INPUT(SurfaceRendering,In2,"Input image to the SurfaceRendering",vtkImageData*,"");
BBTK_INPUT(SurfaceRendering,In3,"Input image to the SurfaceRendering",vtkImageData*,"");
BBTK_INPUT(SurfaceRendering,In4,"Input image to the SurfaceRendering",vtkImageData*,"");
BBTK_OUTPUT(SurfaceRendering,Out1,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(SurfaceRendering,Out2,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(SurfaceRendering,Out3,"Output resulting image",vtkImageData*,"");
BBTK_OUTPUT(SurfaceRendering,Out4,"Output resulting image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(SurfaceRendering);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuSurfaceRendering_h_INCLUDED__
#endif // _USE_WXWIDGETS_

