/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuColorBar_h_INCLUDED__
#define __bbcreaMaracasVisuColorBar_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "bbcreaMaracasVisuPackage.h"
#include "pColorBar.h"


namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ ColorBar
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ColorBar,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(Orientation, int );
	BBTK_DECLARE_INPUT(InW, int );
	BBTK_DECLARE_INPUT(InH, int );
	BBTK_DECLARE_INPUT(InMax, int );
	BBTK_DECLARE_INPUT(InMin, int );
	BBTK_DECLARE_INPUT(Reds, std::vector<int> );
	BBTK_DECLARE_INPUT(Greens, std::vector<int> );
	BBTK_DECLARE_INPUT(Blues, std::vector<int> );
	BBTK_DECLARE_INPUT(Values, std::vector<int> );
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

  private:
	pColorBar *mwxwidget;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ColorBar,bbtk::WxBlackBox);
BBTK_NAME("ColorBar");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Degrade Color Bar Window");
//BBTK_CATEGORY("__CategoryBlackBox__");
  BBTK_INPUT(ColorBar,Orientation,"Orientation ", int,"");
  BBTK_INPUT(ColorBar,InW,"Width ", int,"");
  BBTK_INPUT(ColorBar,InH,"Height ", int,"");
  BBTK_INPUT(ColorBar,InMax,"Max value ", int,"" );
  BBTK_INPUT(ColorBar,InMin, "Min value ",int,"" );
  BBTK_INPUT(ColorBar,Reds, "Reds ",std::vector<int>,"");
  BBTK_INPUT(ColorBar,Greens, "Greens ",std::vector<int>,"");
  BBTK_INPUT(ColorBar,Blues, "Blues ",std::vector<int>,"");
  BBTK_INPUT(ColorBar,Values, "Values ",std::vector<int>,"");
BBTK_END_DESCRIBE_BLACK_BOX(ColorBar);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuColorBar_h_INCLUDED__
#endif // _USE_WXWIDGETS_

