/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuShowNPoints_h_INCLUDED__
#define __bbcreaMaracasVisuShowNPoints_h_INCLUDED__
#include "bbtkWxBlackBox.h"


#include "vtkImageData.h"

#include "WidgetShowNPoints.h"

namespace bbcreaMaracasVisu
{


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

class ShowNPoints;

class WidgetShowNPointsBox : public WidgetShowNPoints
{
public:
	WidgetShowNPointsBox( wxWindow *parent,  ShowNPoints *box, int type);
	~WidgetShowNPointsBox(); 
	void UpdatePoints(wxCommandEvent &event);
private:
	void						SetOutputBox();
	ShowNPoints					*mbbShowNPoints;
};

class /*BBTK_EXPORT*/ ShowNPoints
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ShowNPoints,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(In                 , std::vector<double>       );
  BBTK_DECLARE_INPUT(Renderer           , vtkRenderer*              );
  BBTK_DECLARE_INPUT(Image              , vtkImageData*             );
  BBTK_DECLARE_INPUT(Colour             , std::vector<double>       );
  BBTK_DECLARE_INPUT(Opacity            , double                    );
  BBTK_DECLARE_INPUT(Radio              , double                    );
  BBTK_DECLARE_INPUT(InitLstPointsX     , std::vector<double>       );
  BBTK_DECLARE_INPUT(InitLstPointsY     , std::vector<double>       );
  BBTK_DECLARE_INPUT(InitLstPointsZ     , std::vector<double>       );
  BBTK_DECLARE_INPUT(InitLstLabels      , std::vector<std::string>  );
  BBTK_DECLARE_INPUT(InitLstIndexs      , std::vector<int>          );
  BBTK_DECLARE_INPUT(Type, int );

  BBTK_DECLARE_OUTPUT( lstPointsX       , std::vector<double>       );
  BBTK_DECLARE_OUTPUT( lstPointsY       , std::vector<double>       );
  BBTK_DECLARE_OUTPUT( lstPointsZ       , std::vector<double>       );
  BBTK_DECLARE_OUTPUT( lstLabels        , std::vector<std::string>  );
  BBTK_DECLARE_OUTPUT( lstIndexs        , std::vector<int>          );
  BBTK_DECLARE_OUTPUT( lstSelectedIndexs, std::vector<int>          );
  BBTK_DECLARE_OUTPUT( WidgetShowNPoints, WidgetShowNPoints*        );
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);
  double backOpacity;
    
private:
    bool                    firsttime;
	WidgetShowNPointsBox    *mwxwidget;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ShowNPoints,bbtk::WxBlackBox);
  BBTK_NAME("ShowNPoints");
  BBTK_AUTHOR("Eduardo DAVILA");
  BBTK_DESCRIPTION("widget that shows N moints in 3D (vtkActors)");
  BBTK_CATEGORY("widgetVtk");

  BBTK_INPUT(ShowNPoints,In,"One Point",std::vector<double>,"");
  BBTK_INPUT(ShowNPoints,Renderer,"Renderer",vtkRenderer*,"");
  BBTK_INPUT(ShowNPoints,Image,"vktkImageData",vtkImageData*,"");
  BBTK_INPUT(ShowNPoints,Colour,"Colour of the actor",std::vector<double>,"colour");
  BBTK_INPUT(ShowNPoints,Opacity,"Opacity of the actor 0..1 (default 1)",double,"");
  BBTK_INPUT(ShowNPoints,Radio,"Radio of the spheres 1..50 (default 10)",double,"");
  BBTK_INPUT(ShowNPoints,InitLstPointsX,"Initial lst of points X",std::vector<double>,"");
  BBTK_INPUT(ShowNPoints,InitLstPointsY,"Initial lst of points Y",std::vector<double>,"");
  BBTK_INPUT(ShowNPoints,InitLstPointsZ,"Initial lst of points Z",std::vector<double>,"");
  BBTK_INPUT(ShowNPoints,InitLstLabels,"Initial lst of labels",std::vector<std::string>,"");
  BBTK_INPUT(ShowNPoints,InitLstIndexs,"Initial lst of indexs sizes",std::vector<int>,"");
  BBTK_INPUT(ShowNPoints,Type,"Type of the widget. 0(default): N-points, 1:Just one point, 2:Add/DeleteAll points, 3:As 0 with out save/load option, 4 Multiple NPoints",int,"");

  BBTK_OUTPUT(ShowNPoints , lstPointsX          , " list of points X "      , std::vector<double> ,""       );
  BBTK_OUTPUT(ShowNPoints , lstPointsY          , " list of points Y "      , std::vector<double> ,""       );
  BBTK_OUTPUT(ShowNPoints , lstPointsZ          , " list of points Z "      , std::vector<double> ,""       );
  BBTK_OUTPUT(ShowNPoints , lstLabels           , " list of labels "        , std::vector<std::string> ,""  );
  BBTK_OUTPUT(ShowNPoints , lstIndexs           , " list of index sizes "   , std::vector<int> ,""          );
  BBTK_OUTPUT(ShowNPoints , lstSelectedIndexs   , " list of points Z "      , std::vector<int> ,""          );
  BBTK_OUTPUT(ShowNPoints , WidgetShowNPoints   , " WidgetShowNPoints "     , WidgetShowNPoints* ,""        );

BBTK_END_DESCRIBE_BLACK_BOX(ShowNPoints);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuShowNPoints_h_INCLUDED__
#endif // _USE_WXWIDGETS_
