/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_VTK_

#ifndef __bbgdcmvtkGetXCoherentInfoGdcmReader_h_INCLUDED__
#define __bbgdcmvtkGetXCoherentInfoGdcmReader_h_INCLUDED__

#include "bbgdcmvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#if defined(USE_GDCM)
#include "vtkGdcmReader.h"
#endif

#if defined(USE_GDCM2)
#include "vtkGDCMImageReader.h"
#endif

#include "gdcmFile.h"
#include "gdcmSerieHelper.h"

#include "vtkImageData.h"
namespace bbgdcmvtk
{
	typedef std::map<std::string, std::string> 	MapInfoDicom;
	typedef std::vector< MapInfoDicom > 		VectorMapInfoDicom;

class bbgdcmvtk_EXPORT GetXCoherentInfoGdcmReader
 : 
   public bbtk::AtomicBlackBox
{

  BBTK_BLACK_BOX_INTERFACE(GetXCoherentInfoGdcmReader,bbtk::AtomicBlackBox);

  BBTK_DECLARE_INPUT(In				            , std::vector<std::string>);
  BBTK_DECLARE_INPUT(IPPSort		            , bool);
  BBTK_DECLARE_INPUT(DicomTags		            , std::vector<std::string>);
  BBTK_DECLARE_INPUT(ReadRaw		            , bool);
  BBTK_DECLARE_INPUT(RespectSerieUID            , bool);
  BBTK_DECLARE_INPUT(DropDuplicatePositions     , bool);

  BBTK_DECLARE_OUTPUT(Out			            , vtkImageData *);
  BBTK_DECLARE_OUTPUT(OutFileNames              , std::vector<std::string>);
  BBTK_DECLARE_OUTPUT(IPP			            , std::vector<double>);
  BBTK_DECLARE_OUTPUT(IOP			            , std::vector<double>);
  BBTK_DECLARE_OUTPUT(PixelSpacing	            , std::vector<double>);
  BBTK_DECLARE_OUTPUT(DicomInfo		            , VectorMapInfoDicom);

  BBTK_PROCESS(Process);
  void Process();
    
  void Process2();
  
	vtkImageData* CreateDefaultImage();


  private:

#if defined USE_GDCM
		GDCM_NAME_SPACE::File *f;
		GDCM_NAME_SPACE::SerieHelper *sh;
		vtkGdcmReader *reader;
#endif
#if defined USE_GDCM2
		vtkGDCMImageReader *reader;
#endif
};

  //=================================================================
  // UserBlackBox description
BBTK_BEGIN_DESCRIBE_BLACK_BOX(GetXCoherentInfoGdcmReader,bbtk::AtomicBlackBox);
  BBTK_NAME("GetXCoherentInfoGdcmReader");
  BBTK_AUTHOR("jpr, eduardo");
  BBTK_DESCRIPTION("Get Dicom info from a File Set (a list of Dicom image file names) and read (as a vtkImageData)");
  BBTK_CATEGORY("");

  BBTK_INPUT(GetXCoherentInfoGdcmReader,In				        ,"List of Dicom image file names", std::vector<std::string>,"");
  BBTK_INPUT(GetXCoherentInfoGdcmReader,IPPSort			        ,"Sort on Image Position Patient", bool,"");
  BBTK_INPUT(GetXCoherentInfoGdcmReader,DicomTags		        ,"Dicom Tags (vector of Dicom tags ex: D0028_0030  D0020_0037)", std::vector<std::string>,"");
  BBTK_INPUT(GetXCoherentInfoGdcmReader,ReadRaw		            ,"(default true) false: not read raw just dicom tags", bool,"");
  BBTK_INPUT(GetXCoherentInfoGdcmReader,RespectSerieUID         ,"(default true) Respect Serie UID to be read", bool,"");
  BBTK_INPUT(GetXCoherentInfoGdcmReader,DropDuplicatePositions  ,"(default true) Drop slices with Duplicate Positions", bool,"");


  BBTK_OUTPUT(GetXCoherentInfoGdcmReader,Out			        ,"Output image"					        , vtkImageData *,"");
  BBTK_OUTPUT(GetXCoherentInfoGdcmReader,OutFileNames           ,"List of the files in the good order"  , std::vector<std::string>,"");
  BBTK_OUTPUT(GetXCoherentInfoGdcmReader,IPP			        ,"Image Position (Patient)"		        , std::vector<double>,"");
  BBTK_OUTPUT(GetXCoherentInfoGdcmReader,IOP			        ,"Image Orientation (Patient)"	        , std::vector<double>,"");
  BBTK_OUTPUT(GetXCoherentInfoGdcmReader,PixelSpacing	        ,"Pixel Spacing"				        , std::vector<double>,"");
  BBTK_OUTPUT(GetXCoherentInfoGdcmReader,DicomInfo		        ,"vector of maps of Dicom tags"	        , VectorMapInfoDicom,"");
BBTK_END_DESCRIBE_BLACK_BOX(GetXCoherentInfoGdcmReader);
} // EO namespace bbgdcmvtk

#endif // __bbgdcmvtkGetXCoherentInfoGdcmReader_h_INCLUDED__

#endif //_USE_VTK_
