/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkAnyImageToTypedImage.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.10 $
=========================================================================*/




#ifdef _USE_ITK_

#ifndef __bbitkAnyImageToTypedImage_h_INCLUDED__
#define __bbitkAnyImageToTypedImage_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"

namespace bbitk
{

  //=================================================================
  // BlackBox declaration
  template <class itkImageTypePointer>
  class AnyImageToTypedImage : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(AnyImageToTypedImage,
				      bbtk::AtomicBlackBox,
				      itkImageTypePointer);
    BBTK_DECLARE_INPUT(In,anyImagePointer);
    BBTK_DECLARE_OUTPUT(Out,itkImageTypePointer);
    BBTK_PROCESS(DoIt);
    void DoIt();
  };
  //=================================================================
  
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(AnyImageToTypedImage,
				      bbtk::AtomicBlackBox);
  BBTK_NAME(bbtk::HumanTypeName<anyImagePointer>() + "To"
	    +bbtk::HumanTypeName<T>());
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Converts a generic itk image pointer ("+
		   bbtk::HumanTypeName<anyImagePointer>()+
		   ") into a typed itk image pointer ("+
		   bbtk::HumanTypeName<T>()+")");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_TEMPLATE_INPUT(AnyImageToTypedImage,In,
		      "Input generic image pointer",anyImagePointer);
  BBTK_TEMPLATE_OUTPUT(AnyImageToTypedImage,Out,
			"Output typed image pointer",T);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(AnyImageToTypedImage);
  //=================================================================
  
  //=================================================================
  template <class itkImageTypePointer>
  void AnyImageToTypedImage<itkImageTypePointer>::DoIt()
  {
    if ( bbGetInputIn().type() == typeid(itkImageTypePointer) )
      {
	bbSetOutputOut ( bbGetInputIn().template unsafe_get < itkImageTypePointer >() );
      }
    else 
      {
	bbtkError(this->bbGetFullName()<<+" : transform of <"
		  <<bbtk::TypeName(bbGetInputIn().type())<<"> into <"
		  <<bbtk::TypeName<itkImageTypePointer>()<<"> not implemented");
      }
  }
  //=================================================================


  //===================================================
  template <class T1> 
  void AnyImageToTypedImage<T1>::bbUserSetDefaultValues() {}
  template <class T1> 
  void AnyImageToTypedImage<T1>::bbUserInitializeProcessing(){}
  template <class T1> 
  void AnyImageToTypedImage<T1>::bbUserFinalizeProcessing() {}
  //===================================================
  













  //=================================================================
  // BlackBox declaration
  template <class itkImageTypePointer, class itkImageTypeConstPointer>
  class AnyImageToConstTypedImage : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE2_BLACK_BOX_INTERFACE(AnyImageToConstTypedImage,
				       bbtk::AtomicBlackBox,
				       itkImageTypePointer,
				       itkImageTypeConstPointer);
    BBTK_DECLARE_INPUT(In,anyImagePointer);
    BBTK_DECLARE_OUTPUT(Out,itkImageTypeConstPointer);
    BBTK_PROCESS(DoIt);
    void DoIt();
  };
  //=================================================================
  
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE2_BLACK_BOX(AnyImageToConstTypedImage,
				       bbtk::AtomicBlackBox);
  BBTK_NAME(bbtk::HumanTypeName<anyImagePointer>() + "To" +
	    bbtk::HumanTypeName<T2>());
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Converts a generic itk image pointer ("+
		   bbtk::HumanTypeName<anyImagePointer>()+
		   ") into a const typed itk image pointer ("+
		   bbtk::HumanTypeName<T2>()+")");
  BBTK_CATEGORY("adaptor");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_TEMPLATE2_INPUT(AnyImageToConstTypedImage,In,
		      "Input generic image pointer",anyImagePointer);
  BBTK_TEMPLATE2_OUTPUT(AnyImageToConstTypedImage,Out,
			"Output const typed image pointer",T2);
  BBTK_END_DESCRIBE_TEMPLATE2_BLACK_BOX(AnyImageToConstTypedImage);
  //=================================================================
  
  //=================================================================
  template <class itkImageTypePointer, class itkImageTypeConstPointer>
  void AnyImageToConstTypedImage<itkImageTypePointer,
				  itkImageTypeConstPointer>::DoIt()
  {
    if ( bbGetInputIn().type() == typeid(itkImageTypeConstPointer) )
      {
	bbSetOutputOut ( bbGetInputIn().template unsafe_get < itkImageTypeConstPointer >() );
      }
    else if ( bbGetInputIn().type() == typeid(itkImageTypePointer) )
      {
	bbSetOutputOut ( bbGetInputIn().template unsafe_get < itkImageTypePointer >() );
      }
    else 
      {
	bbtkError(this->bbGetFullName()<<+" : transform of <"
		  <<bbtk::TypeName(bbGetInputIn().type())<<"> into <"
		  <<bbtk::TypeName<itkImageTypeConstPointer>()<<"> not implemented");
      }
  }
  //=================================================================

  //===================================================
  template <class T1, class T2> 
  void AnyImageToConstTypedImage<T1,T2>::bbUserSetDefaultValues() {}
  template <class T1, class T2> 
  void AnyImageToConstTypedImage<T1,T2>::bbUserInitializeProcessing(){}
  template <class T1, class T2> 
  void AnyImageToConstTypedImage<T1,T2>::bbUserFinalizeProcessing() {}
  //===================================================
  







}
#endif
#endif
