/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkvtkitkImage2vtkImageData.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:49 $
  Version:   $Revision: 1.11 $
=========================================================================*/



/**
 * \file 
 * \brief class itkImage2vtkImageData : converts a generic itkImage to a vtkImageData*
 */
/**
 * \class itkImage2vtkImageData 
 * \brief converts a generic itkImage to a vtkImageData*
 */
#ifdef _USE_ITK_
#ifdef _USE_VTK_

#ifndef __bbitkvtkitkImage2vtkImageData_h__
#define __bbitkvtkitkImage2vtkImageData_h__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"
#include "vtkImageData.h"

namespace bbitkvtk
{

  class itkImage2vtkImageData : public bbtk::AtomicBlackBox  
  {
    
    BBTK_BLACK_BOX_INTERFACE(itkImage2vtkImageData,
			     bbtk::AtomicBlackBox);

    BBTK_DECLARE_INPUT(In,  bbitk::anyImagePointer);
    BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
    BBTK_PROCESS(Convert);
    void Convert();

  private:
    // Convert method template on type of the itk image 
    // embedded in the input itkImage*
    template<class T> void Convert();
    // stores the pointer on the template itk::ImageToVTKImageFilter 
    itk::ProcessObject::Pointer mConverter;
  }; 
  

  //=================================================================
  // AtomicBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(itkImage2vtkImageData,bbtk::AtomicBlackBox);
  BBTK_NAME("itkImage2vtkImageData");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Converts a generic itkImage to a vtkImageData");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_INPUT(itkImage2vtkImageData,In,
	     "Input itkImage",bbitk::anyImagePointer,"");
  BBTK_OUTPUT(itkImage2vtkImageData,Out,
	      "Output vtkImageData*",
	      vtkImageData*,"");
  BBTK_END_DESCRIBE_BLACK_BOX(itkImage2vtkImageData);
  //=================================================================


}
//namespace bbitkvtk
#endif
// _USE_VTK_
#endif
// _USE_ITK_

#endif
