/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdCastVector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.8 $
=========================================================================*/



#ifndef __bbstdCastVector_h_INCLUDED__
#define __bbstdCastVector_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"
#include <vector>

namespace bbstd 
{
  
  //=================================================================
  // BlackBox declaration
  template < class T, class U >
  class bbstd_EXPORT CastVector : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE2_BLACK_BOX_INTERFACE(CastVector,bbtk::AtomicBlackBox , T , U );
    BBTK_DECLARE_INPUT(In , std::vector<T> );
    BBTK_DECLARE_OUTPUT(Out , std::vector<U> );
    BBTK_PROCESS(DoIt);
    void DoIt() {  
//      bbtkDebugMessage("Data",5,"bbstd::CastVector In  = "
//		       << bbGetInputIn() <<" <"<<bbtk::HumanTypeName< T >()
//		       <<">"<<std::endl);
//      bbSetOutputOut( static_cast< U >(bbGetInputIn()) );

  bbmOutputOut.clear();

    typename std::vector<T>::const_iterator i;
    for (i=bbmInputIn.begin();i!=bbmInputIn.end();++i)
    {
      bbmOutputOut.push_back( *i );
    }


//      bbtkDebugMessage("Data",5,"bbstd::CastVector Out = "
//		       <<( U )bbGetInputIn()<<" <"<<bbtk::HumanTypeName< U >()
//		       <<">"<<std::endl);
    }
  };
  //=================================================================
  
  
  
  
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE2_BLACK_BOX(CastVector,bbtk::AtomicBlackBox);
  BBTK_NAME("CastVector"+bbtk::HumanTypeName< T1 >()+"To"+bbtk::HumanTypeName< T2 >());
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Static CastVector from "+bbtk::HumanTypeName< T1 >()+" ("
		   +bbtk::TypeName< T1 >()+") to "+bbtk::HumanTypeName< T2 >()
		   +" ("+bbtk::TypeName< T2 >()+")");
  BBTK_DEFAULT_ADAPTOR();
  typedef std::vector<T1> T1vector;
  BBTK_TEMPLATE2_INPUT(CastVector,In,"Input", T1vector );
  typedef std::vector<T2> T2vector;
  BBTK_TEMPLATE2_OUTPUT(CastVector,Out,"Output", T2vector );
  BBTK_END_DESCRIBE_TEMPLATE2_BLACK_BOX(CastVector);
  //=================================================================

  template <class T, class U> void CastVector< T , U >::bbUserSetDefaultValues() {}
  template <class T, class U> void CastVector< T , U >::bbUserInitializeProcessing() {}
  template <class T, class U> void CastVector< T , U >::bbUserFinalizeProcessing() {}


} // namespace bbstd

#endif // __bbstdCastVector_h_INCLUDED__
  
