/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdConcatStrings.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.9 $
=========================================================================*/


#ifndef __bbstdConcatStrings_h_INCLUDED__
#define __bbstdConcatStrings_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  class bbstd_EXPORT ConcatStrings
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(ConcatStrings,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In1, std::string);
    BBTK_DECLARE_INPUT(In2, std::string);
    BBTK_DECLARE_INPUT(In3, std::string);
    BBTK_DECLARE_INPUT(In4, std::string);
    BBTK_DECLARE_INPUT(In5, std::string);
    BBTK_DECLARE_INPUT(In6, std::string);
    BBTK_DECLARE_INPUT(In7, std::string);
    BBTK_DECLARE_INPUT(In8, std::string);
    BBTK_DECLARE_INPUT(In9, std::string);
    BBTK_DECLARE_INPUT(In10,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_DECLARE_OUTPUT(Box_ConcatStrings,ConcatStrings*);
    BBTK_PROCESS(DoProcess);
    void DoProcess();
  };

  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ConcatStrings,bbtk::AtomicBlackBox);
  BBTK_NAME("ConcatStrings");
  BBTK_AUTHOR("jean-pierre.roux@creatis.insa-lyon.fr");
  BBTK_CATEGORY("misc");
  BBTK_DESCRIPTION("(C++,Python,JavaScript) String concatenation");
  BBTK_INPUT(ConcatStrings,In1, "String 1", std::string,"");
  BBTK_INPUT(ConcatStrings,In2, "String 2", std::string,"");  
  BBTK_INPUT(ConcatStrings,In3, "String 3", std::string,"");  
  BBTK_INPUT(ConcatStrings,In4, "String 4", std::string,"");  
  BBTK_INPUT(ConcatStrings,In5, "String 5", std::string,"");  
  BBTK_INPUT(ConcatStrings,In6, "String 6", std::string,"");  
  BBTK_INPUT(ConcatStrings,In7, "String 7", std::string,"");  
  BBTK_INPUT(ConcatStrings,In8, "String 8", std::string,"");  
  BBTK_INPUT(ConcatStrings,In9, "String 9", std::string,"");  
  BBTK_INPUT(ConcatStrings,In10,"String 10",std::string,"");  
  BBTK_OUTPUT(ConcatStrings,Out,"Concatenated string",std::string,"");
  BBTK_OUTPUT(ConcatStrings,Box_ConcatStrings,"bbtk Box ConcatStrings",ConcatStrings*,"");
  BBTK_END_DESCRIBE_BLACK_BOX(ConcatStrings);

}
// EO namespace bbstd

#endif //  __bbstdConcatStrings_h_INCLUDED__


