/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdConfiguration.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.12 $
=========================================================================*/


#ifndef __bbstdConfiguration_h_INCLUDED__
#define __bbstdConfiguration_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  class bbstd_EXPORT Configuration
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(Configuration,bbtk::AtomicBlackBox);
    BBTK_DECLARE_OUTPUT(BinPath,std::string);
    BBTK_DECLARE_OUTPUT(DataPath,std::string);
    BBTK_DECLARE_OUTPUT(DocPath,std::string);
    BBTK_DECLARE_OUTPUT(FileSeparator,std::string);
    BBTK_DECLARE_OUTPUT(SystemType,int);
    BBTK_PROCESS(DoProcess);
    void DoProcess();

  };

  BBTK_BEGIN_DESCRIBE_BLACK_BOX(Configuration,bbtk::AtomicBlackBox);
  BBTK_NAME("Configuration");
  BBTK_AUTHOR("jpr@creatis.insa-lyon [dot] fr");
  BBTK_CATEGORY("misc");
  BBTK_DESCRIPTION("Gets configuration informations");
  BBTK_OUTPUT(Configuration,BinPath,"Binaries path",std::string,"directory name");
  BBTK_OUTPUT(Configuration,DataPath,"Data path",std::string,"directory name");
  BBTK_OUTPUT(Configuration,DocPath,"Documentation path",std::string,"directory name");
  BBTK_OUTPUT(Configuration,FileSeparator,"/ or \\",std::string,"");  
  BBTK_OUTPUT(Configuration,SystemType,"0=Linux 1=Windows",int,"");  
  BBTK_END_DESCRIBE_BLACK_BOX(Configuration);
}
// EO namespace bbstd

#endif //  __bbstdConfiguration_h_INCLUDED__
