/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdGetVectorElement.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.9 $
=========================================================================*/


#ifndef __bbstdGetSubVector_INCLUDED_h__
#define __bbstdGetSubVector_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbstd_EXPORT GetSubVector : public bbtk::AtomicBlackBox
  {
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(GetSubVector,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::vector<T>);
    BBTK_DECLARE_INPUT(I,int);
    BBTK_DECLARE_INPUT(Size,int);
	BBTK_DECLARE_INPUT(ErrorValue,T);
    BBTK_DECLARE_OUTPUT(Out,std::vector<T>);
    BBTK_PROCESS(DoIt);
    void DoIt();
  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(GetSubVector,bbtk::AtomicBlackBox);
  BBTK_NAME("Get"+bbtk::HumanTypeName<std::vector<T> >()+"SubVector");
  BBTK_AUTHOR("info-dev@creatis.insa-lyon.fr");
 // BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("Gets the i-th element from the input vector ("+bbtk::TypeName<std::vector<T> >());
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_INPUT(GetSubVector, In,"Input",Tvector);
  BBTK_TEMPLATE_INPUT(GetSubVector, I, "Input",int);
  BBTK_TEMPLATE_INPUT(GetSubVector, Size, "Input",int);
  BBTK_TEMPLATE_INPUT(GetSubVector, ErrorValue, "ErrorValue",T);
  BBTK_TEMPLATE_OUTPUT(GetSubVector,Out,"Output",Tvector);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(GetSubVector);
  //=================================================================

  //=================================================================
  template <class T>
  void GetSubVector<T>::DoIt()
  {
	int i,iStart,iEnd;
	bool ok	=	true;
	iStart	=	bbGetInputI();  				
	iEnd	=	bbGetInputI() + bbGetInputSize() - 1;  
	if ((iStart<0) || (iEnd<0)) 			{ ok=false; }
	if (iStart>(int)bbGetInputIn().size() ) { ok=false; }
	if (iEnd>=(int)bbGetInputIn().size() ) 	{ ok=false; }



	std::vector<T> tmpVectResult;
	if  ( (ok==true) && (bbGetInputSize()>=1) )
	{	
		for ( i=iStart ; i<=iEnd ; i++)
 		{
			if ( i<(int)bbGetInputIn().size() ) 
			{
				tmpVectResult.push_back( bbGetInputIn()[i] );
			} // if InputI+i

		}// for
	} else {
		tmpVectResult.push_back( bbGetInputErrorValue() );
	} // if
	bbSetOutputOut( tmpVectResult );

  }
  //=================================================================

  //=================================================================  
  template <class T>
  void GetSubVector<T>::bbUserSetDefaultValues()
  {

  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetSubVector<T>::bbUserInitializeProcessing()
  {

  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetSubVector<T>::bbUserFinalizeProcessing()
  {

  }
  //=================================================================

} // namespace bbstd

#endif //__bbstdGetSubVector_INCLUDED_h__

