/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdGetVectorElement.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.9 $
=========================================================================*/


#ifndef __bbstdGetVectorElement_INCLUDED_h__
#define __bbstdGetVectorElement_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbstd_EXPORT GetVectorElement : public bbtk::AtomicBlackBox
  {
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(GetVectorElement,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::vector<T>);
    BBTK_DECLARE_INPUT(I,int);
	BBTK_DECLARE_INPUT(ErrorValue,T);
    BBTK_DECLARE_OUTPUT(Out,T);
    BBTK_PROCESS(DoIt);
    void DoIt();
  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(GetVectorElement,bbtk::AtomicBlackBox);
  BBTK_NAME("Get"+bbtk::HumanTypeName<std::vector<T> >()+"Element");
  BBTK_AUTHOR("info-dev@creatis.insa-lyon.fr");
 // BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("(C++,Python,JavaScript) Gets the i-th element from the input vector ("+bbtk::TypeName<std::vector<T> >());
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_INPUT(GetVectorElement, In,"Input",Tvector);
  BBTK_TEMPLATE_INPUT(GetVectorElement, I, "iElement (default 0)",int);  
  BBTK_TEMPLATE_INPUT(GetVectorElement, ErrorValue, "ErrorValue",T);
  BBTK_TEMPLATE_OUTPUT(GetVectorElement,Out,"Output",T);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(GetVectorElement);
  //=================================================================

  //=================================================================
  template <class T>
  void GetVectorElement<T>::DoIt()
  {
	  if (( bbGetInputI() < (int)bbGetInputIn().size() )  &&  ( bbGetInputI() >= 0 ) )
	  {
		  bbSetOutputOut( bbGetInputIn()[bbGetInputI()] );
	  } else {
		  bbSetOutputOut( bbGetInputErrorValue() );
	  }
  }
  //=================================================================

  //=================================================================  
  template <class T>
  void GetVectorElement<T>::bbUserSetDefaultValues()
  {
	bbSetInputI(0);
  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetVectorElement<T>::bbUserInitializeProcessing()
  {

  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetVectorElement<T>::bbUserFinalizeProcessing()
  {

  }
  //=================================================================

} // namespace bbstd

#endif //__bbstdGetVectorElement_INCLUDED_h__

