/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdGetVectorElement.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.9 $
=========================================================================*/


#ifndef __bbstdGetVectorPointer_INCLUDED_h__
#define __bbstdGetVectorPointer_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbstd_EXPORT GetVectorPointer : public bbtk::AtomicBlackBox
  {
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(GetVectorPointer,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::vector<T>);
    BBTK_DECLARE_OUTPUT(PVec,std::vector<T>*);
    BBTK_DECLARE_OUTPUT(Vec,std::vector<T>);
    BBTK_PROCESS(DoIt);
    void DoIt();
	std::vector<T> vec;
      
      bool firsttime;
  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(GetVectorPointer,bbtk::AtomicBlackBox);
  BBTK_NAME("Get"+bbtk::HumanTypeName<std::vector<T> >()+"Pointer");
  BBTK_AUTHOR("info-dev@creatis.insa-lyon.fr");
 // BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("Gets the the pointer of the input vector ("+bbtk::TypeName<std::vector<T> >());
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_INPUT(GetVectorPointer, In,"Input",Tvector);
//  BBTK_TEMPLATE_INPUT(GetVectorPointer, I, "Input",int);  
//  BBTK_TEMPLATE_INPUT(GetVectorPointer, ErrorValue, "ErrorValue",T);
//  BBTK_TEMPLATE_OUTPUT(GetVectorPointer,Out,"Output",T);
  BBTK_TEMPLATE_OUTPUT(GetVectorPointer,PVec,"Output Pointer Vector",std::vector<T>*);
BBTK_TEMPLATE_OUTPUT(GetVectorPointer,Vec,"Output Vector",std::vector<T>);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(GetVectorPointer);
  //=================================================================

  //=================================================================
  template <class T>
  void GetVectorPointer<T>::DoIt()
  {
      if (firsttime==true)	  vec = bbGetInputIn();
      firsttime=false;
	  bbSetOutputPVec( &vec );
      bbSetOutputVec( vec );
  }
  //=================================================================

  //=================================================================  
  template <class T>
  void GetVectorPointer<T>::bbUserSetDefaultValues()
  {
      firsttime=true;
  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetVectorPointer<T>::bbUserInitializeProcessing()
  {

  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetVectorPointer<T>::bbUserFinalizeProcessing()
  {

  }
  //=================================================================

} // namespace bbstd

#endif //__bbstdGetVectorPointer_INCLUDED_h__

