/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdMakeFileName.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.10 $
=========================================================================*/


#ifndef __bbstdMakeFileName_h_INCLUDED__
#define __bbstdMakeFileName_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  class bbstd_EXPORT MakeFileName
    :
  public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(MakeFileName,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(Directory, std::string);
    BBTK_DECLARE_INPUT(File,      std::string);
    BBTK_DECLARE_INPUT(Extent,    std::string);
    BBTK_DECLARE_OUTPUT(Out,      std::string);
    BBTK_PROCESS(DoProcess);
    void DoProcess();
  };

  BBTK_BEGIN_DESCRIBE_BLACK_BOX(MakeFileName,bbtk::AtomicBlackBox);
  BBTK_NAME("MakeFileName");
  BBTK_AUTHOR("jpr@creatis.insa-lyon.fr");
  BBTK_CATEGORY("misc");
  BBTK_DESCRIPTION("Makes a kosher file name");
  BBTK_INPUT(MakeFileName,Directory,"Directory Name",std::string,"directory name");
  BBTK_INPUT(MakeFileName,File,     "File Name",     std::string,"file name");
  BBTK_INPUT(MakeFileName,Extent,   "Extention",     std::string,"file extension");
  
  BBTK_OUTPUT(MakeFileName,Out,"Full File Name",std::string,"file name");
  BBTK_END_DESCRIBE_BLACK_BOX(MakeFileName);

}
// EO namespace bbstd

#endif //  __bbstdMakeFileName_h_INCLUDED__
