/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbstdMixingVectors_h_INCLUDED__
#define __bbstdMixingVectors_h_INCLUDED__
#include "bbstd_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

namespace bbstd
{

class bbstd_EXPORT MixingVectors
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(MixingVectors,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,std::vector<double>);
  BBTK_DECLARE_INPUT(In2,std::vector<double>);
  BBTK_DECLARE_INPUT(In3,std::vector<double>);
  BBTK_DECLARE_INPUT(In4,std::vector<double>);
  BBTK_DECLARE_INPUT(In5,std::vector<double>);
  BBTK_DECLARE_INPUT(In6,std::vector<double>);
  BBTK_DECLARE_INPUT(In7,std::vector<double>);
  BBTK_DECLARE_INPUT(In8,std::vector<double>);
  BBTK_DECLARE_INPUT(In9,std::vector<double>);
  BBTK_DECLARE_INPUT(In10,std::vector<double>);
  BBTK_DECLARE_OUTPUT(Out,std::vector<double>);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(MixingVectors,bbtk::AtomicBlackBox);
BBTK_NAME("MixingVectors");
BBTK_AUTHOR("Claire Mouton");
BBTK_DESCRIPTION("Transforms a set of vectors of double into a single vector of double (starting by the first values of each vector, followed by the second values of each vector, etc.)");
BBTK_CATEGORY("std");
BBTK_INPUT(MixingVectors,In1,"1st input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In2,"2nd input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In3,"3rd input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In4,"4th input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In5,"5th input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In6,"6th input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In7,"7th input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In8,"8th input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In9,"9th input vector",std::vector<double>,"");
BBTK_INPUT(MixingVectors,In10,"10th input vector",std::vector<double>,"");
BBTK_OUTPUT(MixingVectors,Out,"Mixed vector",std::vector<double>,"");
BBTK_END_DESCRIBE_BLACK_BOX(MixingVectors);
}
// EO namespace bbstd

#endif // __bbstdMixingVectors_h_INCLUDED__

