/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdSharedMemory.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.2 $
=========================================================================*/

#ifndef __bbstdSharedMemory_h_INCLUDED_H__
#define __bbstdSharedMemory_h_INCLUDED_H__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
#define BBTK_MB_DECLARE_INPUT(NAME,TYPE)				\
  protected:								\
  TYPE bbmInput##NAME;							\
public:									\
  TYPE bbGetInput##NAME ()						\
  { return bbmInput##NAME; }						\
    void bbSetInput##NAME (TYPE d)					\
    { bbmInput##NAME = d;						\
      if (mCanSet) { bbSetOutputOut(d); mCanSet = false; } }				

  //==================================================================
  class bbstd_EXPORT SharedMemory
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(SharedMemory,bbtk::AtomicBlackBox);

//    BBTK_DECLARE_INPUT(In,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In,bbtk::Data);

    BBTK_MB_DECLARE_INPUT(In1,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In2,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In3,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In4,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In5,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In6,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In7,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In8,bbtk::Data);
    BBTK_MB_DECLARE_INPUT(In9,bbtk::Data);
    BBTK_DECLARE_OUTPUT(Out,bbtk::Data);
    BBTK_PROCESS(DoProcess);
    void DoProcess();
  protected:
    //    virtual void bbUserConstructor();
    virtual void bbSetStatusAndPropagate(bbtk::BlackBoxInputConnector* c,
					 bbtk::IOStatus s);
    bool mCanSet;
    bool firsttime;
 };
  //==================================================================
  
#undef BBTK_MB_DECLARE_INPUT  

  //==================================================================
  // We have to create a particular SetFunctor for SharedMemory because
  // its input is of type bbtk::Data (i.e. any) and :
  // 1) an any cannot store an any (construction with an any invokes the copy constr.)
  // 2) we cannot invoke the Set method with the content of the any because 
  //   it expects an any 
  // hence the Set method of the functor **MUST NOT** extract the 
  // content of the Data prior to invoking the set method of the box
  class SharedMemorySetFunctor : public bbtk::AtomicBlackBoxSetFunctor
  {
  public:
    /// Type of pointer on a UBB::Set method  
    typedef void (SharedMemory::*SetMethodPointerType)(bbtk::Data);
    
    /// Construction with the pointer on the Set method
    SharedMemorySetFunctor(SetMethodPointerType s) :
       mSetMethodPointer(s) 
       {
       }
    
    /// Concrete application of the Set method of object o
    void Set(bbtk::AtomicBlackBox* o, const bbtk::Data& d)
    { 
      bbtkDebugMessage("data",9,"SharedMemorySetfunctor::Set("<<
		       bbtk::HumanTypeName(d.type())<<
		       ")"<<std::endl);
      (((SharedMemory*)o)->*mSetMethodPointer)(d);
    }
    
    /// 
    bbtk::TypeInfo GetTypeInfo() const { return typeid(bbtk::Data); }
    std::string GetTypeName() const { return bbtk::TypeName<bbtk::Data>(); }
    std::string GetHumanTypeName() const { return bbtk::HumanTypeName<bbtk::Data>(); }
    bool IsPointerType() const { return false; }
    void BruteForceSetPointer(bbtk::AtomicBlackBox*, void*) {}
  private:
    ///  Pointer on the Set method  
    SetMethodPointerType mSetMethodPointer;
  };
  //===========================================================================
  
#define MAGIC_BOX_INPUT(NAME)						\
  AddInputDescriptor							\
  (new bbtk::AtomicBlackBoxInputDescriptor				\
   (typeid(SharedMemoryDescriptor),						\
    #NAME,"Input data","",						\
    new bbtk::AtomicBlackBoxTGetFunctor<SharedMemory,bbtk::Data,bbtk::Data>	\
    (&SharedMemory::bbGetInput ## NAME),					\
    new SharedMemorySetFunctor (&SharedMemory::bbSetInput ## NAME) ) );		

  //===========================================================================
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(SharedMemory,bbtk::AtomicBlackBox);
  BBTK_NAME("SharedMemory");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_CATEGORY("misc");
  BBTK_DESCRIPTION("Implements a memory which can be shared by different boxes. The value of the output is the value of the lower index input which has changed. It is used for example for synchronization issues between boxes.");
  MAGIC_BOX_INPUT(In)	
  MAGIC_BOX_INPUT(In1)	
  MAGIC_BOX_INPUT(In2)	
  MAGIC_BOX_INPUT(In3)	
  MAGIC_BOX_INPUT(In4)	
  MAGIC_BOX_INPUT(In5)	
  MAGIC_BOX_INPUT(In6)	
  MAGIC_BOX_INPUT(In7)	
  MAGIC_BOX_INPUT(In8)	
  MAGIC_BOX_INPUT(In9)	

 /*
 AddInputDescriptor
  (new bbtk::AtomicBlackBoxInputDescriptor
   (typeid(SharedMemoryDescriptor),
    "In","Input data","",
    new bbtk::AtomicBlackBoxTGetFunctor<SharedMemory,bbtk::Data,bbtk::Data>
    (&SharedMemory::bbGetInputIn),
    new SharedMemorySetFunctor (&SharedMemory::bbSetInputIn) ) );
 */
  AddOutputDescriptor
  (new bbtk::AtomicBlackBoxOutputDescriptor
   (typeid(SharedMemoryDescriptor),
    "Out","Output data","",
    new bbtk::AtomicBlackBoxTGetFunctor<SharedMemory,bbtk::Data,bbtk::Data>
    (&SharedMemory::bbGetOutputOut),
    new SharedMemorySetFunctor (&SharedMemory::bbSetOutputOut) ) );
  BBTK_END_DESCRIBE_BLACK_BOX(SharedMemory);
  //===========================================================================

}
// namespace bbstd

#endif // __bbstdSharedMemory_h_INCLUDED_H__
