/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdStringToVector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.11 $
=========================================================================*/



#ifndef __bbstdStringToVector_INCLUDED_h__
#define __bbstdStringToVector_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbstd_EXPORT StringToVector : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(StringToVector,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::vector<T>);
    BBTK_PROCESS(DoIt);
    void DoIt(); 
    T decode_item(const std::string&);
  };
  //=================================================================  

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(StringToVector,bbtk::AtomicBlackBox);
  BBTK_NAME("StringTo"+bbtk::HumanTypeName<std::vector<T> >());
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("Converts the content of the input string to a "
		   +bbtk::HumanTypeName<std::vector<T> >()
		   +" ("+bbtk::TypeName<std::vector<T> >()+")");
  BBTK_TEMPLATE_INPUT(StringToVector, In,"Input",std::string);
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_OUTPUT(StringToVector, Out,"Output",Tvector);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(StringToVector);
  //=================================================================
  

  template <class T> void StringToVector<T>::bbUserSetDefaultValues() {}
  template <class T> void StringToVector<T>::bbUserInitializeProcessing() {}
  template <class T> void StringToVector<T>::bbUserFinalizeProcessing() {}
  //=================================================================
  template <class T>
  void StringToVector<T>::DoIt()
  {
    //  std::cout << "StringToVector<"<<bbtk::TypeName<T>()<<">::DoIt()"<<std::endl;
    
    typedef T type;
    std::string delimiters(" ,;");
    std::string str(bbGetInputIn()); 
    //  std::cout << "'"<< str << "'"<<std::endl;
    // Skip delimiters at beginning.
    std::string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    std::string::size_type pos     = str.find_first_of(delimiters, lastPos);
//    bbmOutputOut.clear();
std::vector<T> out;
    while (std::string::npos != pos || std::string::npos != lastPos)
      {
	// Found a token, add it to the vector.
//	bbmOutputOut.push_back( this->decode_item( str.substr(lastPos, pos - lastPos) ) );
	out.push_back( this->decode_item( str.substr(lastPos, pos - lastPos) ) );
	//      std::cout << this->bbGetOutputOut().back() << std::endl;
	// Skip delimiters.  Note the "not_of"
	lastPos = str.find_first_not_of(delimiters, pos);
	// Find next "non-delimiter"
	pos = str.find_first_of(delimiters, lastPos);
      }
bbSetOutputOut (out);
//bbSignalOutputModification();
    //  std::cout << "s=" << this->bbGetOutputOut().size() << std::endl;
  }
  //=================================================================
  
  
} // namespace bbstd

#endif //__bbstdStringToVector_INCLUDED_h__
