/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdStringVectorToNumericalVector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.4 $
=========================================================================*/


#ifndef __bbstdStringVectorToNumericalVector_INCLUDED_h__
#define __bbstdStringVectorToNumericalVector_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbstd_EXPORT StringVectorToNumericalVector : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(StringVectorToNumericalVector,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::vector<std::string>);
    BBTK_DECLARE_OUTPUT(Out,std::vector<T>);
    BBTK_PROCESS(DoIt);
    void DoIt(); 
    T decode_item(const std::string&);
  };
  //=================================================================  

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(StringVectorToNumericalVector,bbtk::AtomicBlackBox);
  BBTK_NAME("VectorStringTo"+bbtk::HumanTypeName<std::vector<T> >());
  BBTK_AUTHOR("jpr@creatis.univ-lyon1.fr");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("Converts the content of the input string vector to a "
		   +bbtk::HumanTypeName<std::vector<T> >()
		   +" ("+bbtk::TypeName<std::vector<T> >()+")");
  BBTK_TEMPLATE_INPUT(StringVectorToNumericalVector, In, "Input", std::vector<std::string>);
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_OUTPUT(StringVectorToNumericalVector, Out, "Output", Tvector);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(StringVectorToNumericalVector);
  //=================================================================
  

  template <class T> void StringVectorToNumericalVector<T>::bbUserSetDefaultValues()     {}
  template <class T> void StringVectorToNumericalVector<T>::bbUserInitializeProcessing() {}
  template <class T> void StringVectorToNumericalVector<T>::bbUserFinalizeProcessing()   {}
  //=================================================================
  template <class T>
  void StringVectorToNumericalVector<T>::DoIt()
  {
    typedef T type; 

    // \TODO :Affecter bbGetInputIn()  un std::vector<std::string> // recopie? // JPR 
    //std::vector<std::string> vect (bbGetInputIn() );

    bbmOutputOut.clear();   
    // get a  std::string, add it to the <std::vector< >>
    int lgt=bbGetInputIn().size();
    for (int i=0; i<lgt; i++)
    {
       bbmOutputOut.push_back( decode_item( bbGetInputIn()[i]) );    
    }
    // bbmOutputOut.clear();   // ? JPR

    // just to see // JPR      
//EED    int lgrOut=this->bbGetOutputOut().size();  
//EED    for (int j=0; j<lgrOut; j++)
//EED    {
//EED       std::cout << this->bbGetOutputOut()[j] << std::endl;    
//EED    }
    // end just to see // JPR  
	  
  }
  //=================================================================
  
  
} // namespace bbstd

#endif //__bbstdStringVectorToNumericalVector_INCLUDED_h__
