/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkAtomicBlackBox.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.12 $
=========================================================================*/


/**
 *  \file 
 *  \brief class bbtk::AtomicBlackBox : ancestor of all user defined (concrete) black boxes which are atomic (vs. ComplexBlackBox objects which are made up of other (atomic or complex) boxes).
 */

/**
 *  \class bbtk::AtomicBlackBox
 *  \brief Ancestor of all user defined (concrete) black boxes which are atomic (vs. complex boxes which are made up of other (atomic or complex) boxes).
 */
 
#ifndef __bbtkAtomicBlackBox_h__
#define __bbtkAtomicBlackBox_h__

#include "bbtkBlackBox.h"
#include "bbtkAtomicBlackBoxDescriptor.h"
namespace bbtk
{

 
  //==================================================================
  class BBTK_EXPORT AtomicBlackBox : public bbtk::BlackBox
  {
    //==================================================================
  public: 
    //==================================================================
    bbtk::BlackBoxDescriptor::Pointer bbGetDescriptor() const
    {
      return bbmDescriptorPointer;
    }
    //==================================================================

    //==================================================================
    /// Gets the output Data of a given label
    Data bbGetOutput( const std::string &label );
    ///  Gets the input Data of a given label
    Data bbGetInput( const std::string &label );
    ///  Sets the data of the output called <name>
    void bbSetOutput( const std::string &name, Data data);
    ///  Sets the data of the input called <name>
    void bbSetInput( const std::string &name, Data data, 
		     bool setModified = true);
    ///  Sets the data of the input called <name>
    void bbBruteForceSetInputPointer( const std::string &name, 
				      void* data, 
				      bool setModified = true);
    //==================================================================

    //==================================================================
    std::string GetObjectInfo() const;      
    size_t GetObjectSize() const;
    size_t GetObjectRecursiveSize() const;
    //==================================================================

    //==================================================================
  protected:
    //==================================================================
    ///  Constructor with the AtomicBlackBox's instance name
    AtomicBlackBox(const std::string &name, bool alloc = true);
    /// Constructor from an existing box (copy) with a new instance name 
    AtomicBlackBox(AtomicBlackBox& from, const std::string &name, 
		 bool alloc = true);
    ///  Destructor
    virtual ~AtomicBlackBox();
    /// 
    virtual void bbLockDescriptor() = 0;
    //==================================================================

    //==================================================================
    /// Calls the user defined processing method.
    /// Overloaded in WxBlackBox to handle widget creation and show
    virtual void bbProcess() { this->bbUserProcess(); }
    //==================================================================

    //==================================================================
    /// User callback which computes the outputs as a function of the inputs. 
    /// It is assumed to be deterministic and thus is only called 
    /// if the inputs have changed 
    virtual void bbUserProcess() 
    {
      bbtkWarning("AtomicBlackBox::bbUserProcess() not overloaded for box '"
		  <<bbGetFullName()
		  <<"' : the box does nothing. Is it a bug or a feature ?"
		  <<std::endl);
    }
    //==================================================================

    //==================================================================
    /// *** TO BE REMOVED WHEN EVERYTHING IS OK ***
    /// CHANGED RETURN TYPE OF bbUserConstructor FROM void TO int
    /// TO PRODUCE COMPILATION ERROR IF AN USER DECLARES THE OLD 
    /// METHOD bbUserConstructor IN ITS BOX
    virtual int bbUserConstructor() { return 0; }
    /// *** TO BE REMOVED WHEN EVERYTHING IS OK ***
    /// THE SAME AS bbUserConstructor
    virtual int bbUserCopyConstructor(bbtk::BlackBox::Pointer) { return 0; }
    /// *** TO BE REMOVED WHEN EVERYTHING IS OK ***
    /// THE SAME AS bbUserConstructor
    virtual int bbUserDestructor() { return 0; }
    //==================================================================    


     //==================================================================
  private:
    //================================================================== 
    /// Default constructor is private : 
    /// derived classes must use the constructor with the AtomicBlackBox's name
    AtomicBlackBox() : BlackBox("") {}
    //================================================================== 

  protected:
    //================================================================== 
    // The pointer on the descriptor
    bbtk::BlackBoxDescriptor::Pointer bbmDescriptorPointer;  
    //================================================================== 

  };
  // Class AtomicBlackBox
  //====================================================================


}
// namespace bbtk


#include "bbtkAtomicBlackBoxMacros.h"

#endif

