/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkAtomicBlackBoxMacros.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.20 $
=========================================================================*/





/**
 *  \file 
 *  \brief Defines macros for the creation of new user black boxes
 */
#ifndef __bbtkAtomicBlackBoxMacros_h__
#define __bbtkAtomicBlackBoxMacros_h__

//============================================================================
/// Declares the standard interface of a AtomicBlackBox 
/// (ctor, New, descriptor related methods)
#define BBTK_BLACK_BOX_INTERFACE_INTERNAL_WITHOUT_NEW(CLASS,PARENT)	\
  BBTK_OBJECT_MINIMAL_INTERFACE;					\
  private:								\
  protected:								\
  CLASS(const std::string& name, bool allocate_connectors = true);	\
  CLASS(Self& from, const std::string& name,				\
	bool allocate_connectors = true);				\
  ~CLASS();								\
  public:								\
  std::string GetObjectName() const					\
  { return std::string(#CLASS)+std::string(" '")			\
      +bbGetNameWithParent()+std::string("'"); }			\
  virtual void bbLockDescriptor();					\
  virtual void bbUserSetDefaultValues();				\
  virtual void bbUserInitializeProcessing();				\
  virtual void bbUserFinalizeProcessing();				\
  virtual void bbRecursiveInitializeProcessing()			\
  {									\
    PARENT::bbRecursiveInitializeProcessing();				\
    CLASS::bbUserInitializeProcessing();				\
  }									\
  virtual void bbRecursiveFinalizeProcessing()				\
  {									\
    CLASS::bbUserFinalizeProcessing();					\
    PARENT::bbRecursiveFinalizeProcessing();				\
  }									\
  private:								\
  CLASS() : PARENT("") {}						\
  CLASS(const CLASS&) : PARENT("") {}					
  
//============================================================================



//============================================================================
/// Declares the standard interface of a AtomicBlackBox 
/// (ctor, New, descriptor related methods)

//EED 2017-08-29  itk3to4
/*
  std::string GetObjectName() 	const				\
*/

#define BBTK_BLACK_BOX_INTERFACE_INTERNAL(CLASS,PARENT)		\
  BBTK_OBJECT_MINIMAL_INTERFACE;				\
  private:								\
  protected:								\
  CLASS(const std::string& name, bool allocate_connectors = true);	\
  CLASS(Self& from, const std::string& name,				\
	bool allocate_connectors = true);				\
  ~CLASS();								\
  public:								\
  std::string GetObjectName()					\
  { return std::string(#CLASS)+std::string(" '")			\
      +bbGetNameWithParent()+std::string("'"); }			\
  inline static Pointer New(const std::string& name)			\
  {									\
    bbtkDebugMessage("object",1,"##> "<<#CLASS				\
		     <<"::New(\""<<name<<"\")"<<std::endl);		\
    Pointer p = MakeBlackBoxPointer(new Self(name));			\
    bbtkDebugMessage("object",1,"<## "<<#CLASS				\
		     <<"::New(\""<<name<<"\")"<<std::endl);		\
    return p;								\
  }									\
  inline bbtk::BlackBox::Pointer bbClone(const std::string& name)	\
  {									\
    bbtkBlackBoxDebugMessage("object",1,"##> "<<#CLASS			\
			     <<"::bbClone(\""<<name<<"\")"<<std::endl);	\
    Pointer p = MakeBlackBoxPointer(new Self(*this,name));		\
    bbtkBlackBoxDebugMessage("object",1,"<## "<<#CLASS			\
		     <<"::bbClone(\""<<name<<"\")"<<std::endl);		\
    return p;								\
  }									\
  virtual void bbLockDescriptor();					\
  virtual void bbUserSetDefaultValues();				\
  virtual void bbUserInitializeProcessing();				\
  virtual void bbUserFinalizeProcessing();				\
  virtual void bbRecursiveInitializeProcessing()			\
  {									\
    PARENT::bbRecursiveInitializeProcessing();				\
    CLASS::bbUserInitializeProcessing();				\
  }									\
  virtual void bbRecursiveFinalizeProcessing()				\
  {									\
    CLASS::bbUserFinalizeProcessing();					\
    PARENT::bbRecursiveFinalizeProcessing();				\
  }									\
  private:								\
  CLASS() : PARENT("") {}						\
  CLASS(const CLASS&) : PARENT("") {}					

//============================================================================

//============================================================================
#define BBTK_BLACK_BOX_INTERFACE(CLASS,PARENT)	\
  public : typedef CLASS Self;				\
  BBTK_BLACK_BOX_INTERFACE_INTERNAL(CLASS,PARENT);
//============================================================================

//============================================================================
#define BBTK_BLACK_BOX_INTERFACE_WITHOUT_NEW(CLASS,PARENT)	\
  public : typedef CLASS Self;				\
  BBTK_BLACK_BOX_INTERFACE_INTERNAL_WITHOUT_NEW(CLASS,PARENT);
//============================================================================

//============================================================================
/// Defines the bbUserProcess method
#define BBTK_PROCESS(CALLBACK)						\
  public:								\
  inline void bbUserProcess()						\
  {									\
    bbtkBlackBoxDebugMessage("process",1,"**> Processing..."		\
			     <<std::endl);				\
    CALLBACK();								\
    bbtkBlackBoxDebugMessage("process",1,"<** Processing"		\
			     <<std::endl);				\
  }
//============================================================================


//============================================================================
/// Declares a new AtomicBlackBox input (to be put in the class interface)
#define BBTK_DECLARE_INPUT(NAME,TYPE)					\
  protected:								\
  TYPE bbmInput##NAME;							\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { return bbmInput##NAME; }						\
  void bbSetInput##NAME (TYPE d)					\
  { bbmInput##NAME = d;							\
    /*bbSetModifiedStatus();*/ }				
//============================================================================

//============================================================================
/// Declares a new AtomicBlackBox output (to be put in the class interface)
#define BBTK_DECLARE_OUTPUT(NAME,TYPE)					\
  protected:								\
  TYPE bbmOutput##NAME;							\
  public:								\
  TYPE bbGetOutput##NAME ()						\
  { return bbmOutput##NAME; }						\
  void  bbSetOutput##NAME (TYPE d)					\
  { bbmOutput##NAME = d; }					
//============================================================================

//============================================================================
/// Declares an inherited AtomicBlackBox input (to be put in the class interface)
#define BBTK_DECLARE_INHERITED_INPUT(NAME,TYPE,GETMETHOD,SETMETHOD)	\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { return GETMETHOD(); }						\
  void bbSetInput##NAME (TYPE d)					\
  { SETMETHOD(d);							\
    /*bbSetModifiedStatus();*/ }			
//============================================================================


//============================================================================
/// Declares an inherited AtomicBlackBox output (to be put in the class interface)
#define BBTK_DECLARE_INHERITED_OUTPUT(NAME,TYPE,GETMETHOD,SETMETHOD)	\
  public:								\
  TYPE bbGetOutput##NAME () const					\
  { return GETMETHOD(); }						\
  void bbSetOutput##NAME (TYPE d)					\
  { SETMETHOD(d); }							
//============================================================================



//============================================================================
#define BBTK_BEGIN_BLACK_BOX_CONSTRUCTOR(CLASS,ALLOC)			\
  bbtkBlackBoxDebugMessage("object",2,"==> "<<#CLASS<<"::"<<#CLASS	\
			   <<"()"<<std::endl);				\
  if (ALLOC)								\
    {									\
      bbLockDescriptor();						\
      bbAllocateConnectors();						\
    }									

//============================================================================

//============================================================================
#define BBTK_END_BLACK_BOX_CONSTRUCTOR(CLASS)				\
  bbtkBlackBoxDebugMessage("object",2,"<== "<<#CLASS<<"::"<<#CLASS	\
			   <<"()"<<std::endl);		
//============================================================================

//============================================================================
#define BBTK_BEGIN_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,FROM,ALLOC)		\
  bbtkBlackBoxDebugMessage("object",2,"==> "<<#CLASS<<"::"<<#CLASS	\
			   <<"("<<FROM.bbGetFullName()			\
			   <<")"<<std::endl);				\
  if (ALLOC)								\
    {									\
      bbLockDescriptor();						\
      bbAllocateConnectors();						\
    }
//============================================================================

//============================================================================
#define BBTK_END_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,FROM,ALLOC)		\
  bbtkBlackBoxDebugMessage("object",2,"<== "<<#CLASS<<"::"<<#CLASS	\
			   <<"("<<FROM.bbGetFullName()			\
			   <<")"<<std::endl);				\
  if (ALLOC)								\
    {									\
      bbCopyIOValues(FROM);						\
    }
//============================================================================

//============================================================================
#define BBTK_BEGIN_BLACK_BOX_DESTRUCTOR(CLASS)				\
  bbtkBlackBoxDebugMessage("object",2,"==> "<<#CLASS <<"::~"<< #CLASS	\
			   <<"()"<<std::endl); \
  bbFinalizeProcessing();						


//============================================================================

//============================================================================
#define BBTK_END_BLACK_BOX_DESTRUCTOR(CLASS)				\
  bbtkBlackBoxDebugMessage("object",2,"<== "<<#CLASS <<"::~"<< #CLASS	\
			   <<"()"<<std::endl);

//============================================================================


//============================================================================
/// AtomicBlackBox std implementation of ctor and dtor
#define BBTK_BLACK_BOX_IMPLEMENTATION(CLASS,PARENT)		\
  CLASS::CLASS(const std::string& name, bool allocate_connectors)	\
    : PARENT(name,false)						\
  {									\
    BBTK_BEGIN_BLACK_BOX_CONSTRUCTOR(CLASS,allocate_connectors);	\
    CLASS::bbUserSetDefaultValues();						\
    BBTK_END_BLACK_BOX_CONSTRUCTOR(CLASS);				\
  }									\
  CLASS::CLASS(CLASS& from,						\
	       const std::string& name, bool allocate_connectors)	\
    : PARENT(from,name,false)						\
  {									\
    BBTK_BEGIN_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,from,allocate_connectors); \
    CLASS::bbUserSetDefaultValues();						\
    BBTK_END_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,from,allocate_connectors);			\
  }									\
  CLASS::~CLASS()							\
  {									\
    BBTK_BEGIN_BLACK_BOX_DESTRUCTOR(CLASS);				\
    BBTK_END_BLACK_BOX_DESTRUCTOR(CLASS);				\
  }									\
  void CLASS::bbLockDescriptor() 					\
  {									\
    bbmDescriptorPointer = CLASS ## Descriptor::Instance();		\
  }
//============================================================================


//============================================================================
/// Begins the AtomicBlackBox description block
#define BBTK_BEGIN_DESCRIBE_BLACK_BOX_BODY(CLASS)			\
  {									\
  public: typedef CLASS ## Descriptor Self;				\
    BBTK_OBJECT_MINIMAL_INTERFACE;					\
  public:								\
    std::string GetObjectName() const					\
    {									\
      return std::string(BBTK_STRINGIFY(CLASS))				\
	+std::string("Descriptor '")+GetFullTypeName()			\
	+std::string("'");						\
    }									\
    size_t GetObjectSize() const { return sizeof(*this); }		\
    bbtk::BlackBox::Pointer NewBlackBox(const std::string& name)	\
    {									\
      return CLASS::New(name);						\
    }									\
    virtual bbtk::AtomicBlackBoxDescriptor::Pointer GetInstance()	const \
      {									\
	return Instance();						\
      }									\
    static bbtk::AtomicBlackBoxDescriptor::Pointer Instance()		\
      {									\
	static bbtk::AtomicBlackBoxDescriptor::WeakPointer i;		\
	bbtk::AtomicBlackBoxDescriptor::Pointer j;			\
	if (!i.lock()) { j = Self::New(); i = j; }			\
	return i.lock();						\
      }									\
    static CLASS ## Descriptor::Pointer New()				\
      {									\
	bbtkDebugMessage("object",1,"##> "<<BBTK_STRINGIFY(CLASS)	\
			 <<"Descriptor::New" <<std::endl);		\
	CLASS ## Descriptor::Pointer p =				\
	  MakePointer(new CLASS ## Descriptor());			\
	bbtkDebugMessage("object",1,"<## "<<BBTK_STRINGIFY(CLASS)	\
			 <<"Descriptor::New" <<std::endl);		\
	return p;							\
      }									\
  protected:								\
    CLASS ## Descriptor()						\
      {									\
	bbtkDebugMessage("object",2,"==> "<<#CLASS<<"Descriptor::"	\
			 <<#CLASS<<"Descriptor()"<<std::endl);		
//============================================================================

//============================================================================
/// Begins the AtomicBlackBox description block
#define BBTK_BEGIN_DESCRIBE_BLACK_BOX(CLASS,PARENT)			\
  class /*BBTK_EXPORT*/ CLASS ## Descriptor : public PARENT ## Descriptor \
  BBTK_BEGIN_DESCRIBE_BLACK_BOX_BODY(CLASS);

//============================================================================
/// Ends the AtomicBlackBox description block
#define BBTK_END_DESCRIBE_BLACK_BOX(CLASS)				\
  bbtkDebugMessage("object",2,"<== "<<#CLASS<<"Descriptor::"		\
		   <<#CLASS<<"Descriptor()"<<std::endl);		\
  }									\
  };									\
  
//============================================================================


//============================================================================
/// Declares the name of a AtomicBlackBox (to be put inside the UBB description block)
#define BBTK_NAME(NAME) SetTypeName(NAME)
//============================================================================

//============================================================================
/// Declares the author of a AtomicBlackBox (to be put inside the UBB description block)
#define BBTK_AUTHOR(AUTHOR) AddToAuthor(AUTHOR)
//============================================================================

//============================================================================
/// Declares the categories of a AtomicBlackBox (to be put inside the UBB description block)
#define BBTK_CATEGORY(CATEGORY) AddToCategory(CATEGORY)
//============================================================================

//============================================================================
/// Declares the description of a AtomicBlackBox (to be put inside the UBB description block)
#define BBTK_DESCRIPTION(DESCR) AddToDescription(DESCR)
//============================================================================

//============================================================================
/// Declares the kind of a AtomicBlackBox (to be put inside the UBB description block)
//#define BBTK_KIND(KIND) SetKind(KIND)
//============================================================================

//============================================================================
/// Declares that the AtomicBlackBox is an adaptor (to be put inside the UBB description block)
#define BBTK_ADAPTOR()			      \
  SetKind(bbtk::BlackBoxDescriptor::ADAPTOR); \
  AddToCategory("adaptor")
//============================================================================

//============================================================================
/// Declares that the AtomicBlackBox is the default adaptor of the package (to be put inside the UBB description block)
#define BBTK_DEFAULT_ADAPTOR()				\
  SetKind(bbtk::BlackBoxDescriptor::DEFAULT_ADAPTOR);	\
  AddToCategory("adaptor")
//============================================================================


//============================================================================
/// Describes a AtomicBlackBox input (to be put inside the UBB description block)
#define BBTK_INPUT(CLASS,NAME,DESCR,TYPE,NATURE)			\
  AddInputDescriptor(new bbtk::AtomicBlackBoxInputDescriptor		\
		     (typeid(CLASS ## Descriptor),			\
		      #NAME,DESCR,NATURE,				\
		      new bbtk::AtomicBlackBoxTGetFunctor<CLASS,TYPE,TYPE > \
		      (&CLASS::bbGetInput##NAME),			\
		      new bbtk::AtomicBlackBoxTSetFunctor<CLASS,TYPE,TYPE > \
		      (&CLASS::bbSetInput##NAME) ) )
//============================================================================

//============================================================================
/// Describes a AtomicBlackBox output (to be put inside the UBB description block)
#define BBTK_OUTPUT(CLASS,NAME,DESCR,TYPE,NATURE)			\
  AddOutputDescriptor(new bbtk::AtomicBlackBoxOutputDescriptor		\
		      (typeid(CLASS ## Descriptor),#NAME,DESCR,NATURE,	\
		       new bbtk::AtomicBlackBoxTGetFunctor<CLASS,TYPE,TYPE > \
		       (&CLASS::bbGetOutput##NAME),			\
		       new bbtk::AtomicBlackBoxTSetFunctor<CLASS,TYPE,TYPE > \
		       (&CLASS::bbSetOutput##NAME) ) )
//============================================================================


//============================================================================
/// Describes a AtomicBlackBox input (to be put inside the UBB description block)
#define BBTK_INPUT_NOCOPY(CLASS,NAME,DESCR,TYPE,NATURE)			\
  AddInputDescriptor(new bbtk::AtomicBlackBoxInputDescriptor		\
		     (typeid(CLASS ## Descriptor),#NAME,DESCR,NATURE,	\
		      new bbtk::AtomicBlackBoxTGetFunctor<CLASS,TYPE,TYPE > \
		      (&CLASS::bbGetInput##NAME),			\
		      new bbtk::AtomicBlackBoxTSetFunctor<CLASS,TYPE,TYPE > \
		      (&CLASS::bbSetInput##NAME),			\
		      false) )
//============================================================================

//============================================================================
/// Describes a AtomicBlackBox output (to be put inside the UBB description block)
#define BBTK_OUTPUT_NOCOPY(CLASS,NAME,DESCR,TYPE,NATURE)		\
  AddOutputDescriptor(new bbtk::AtomicBlackBoxOutputDescriptor		\
		      (typeid(CLASS ## Descriptor),#NAME,DESCR,NATURE,	\
		       new bbtk::AtomicBlackBoxTGetFunctor<CLASS,TYPE,TYPE > \
		       (&CLASS::bbGetOutput##NAME),			\
		       new bbtk::AtomicBlackBoxTSetFunctor<CLASS,TYPE,TYPE > \
		       (&CLASS::bbSetOutput##NAME),\
		       false) )
//============================================================================










//============================================================================
//============================================================================
// Template user black boxes macros
//============================================================================
//============================================================================

//============================================================================
#define BBTK_TEMPLATE_BLACK_BOX_INTERFACE(CLASS,PARENT,T)	\
  public : typedef CLASS<T> Self;				\
  BBTK_BLACK_BOX_INTERFACE_INTERNAL(CLASS,PARENT);
//============================================================================

//============================================================================
/// Begins a template AtomicBlackBox of template param T description block
#define BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(CLASS,PARENT)		\
  template <class T>							\
  class /*BBTK_EXPORT*/ CLASS ## Descriptor : public PARENT ## Descriptor \
  {									\
  public: typedef CLASS ## Descriptor<T> Self;				\
    BBTK_OBJECT_MINIMAL_INTERFACE;					\
  public:								\
    std::string GetObjectName() const					\
    {									\
      return std::string(BBTK_STRINGIFY(CLASS))				\
	+std::string("Descriptor<")+bbtk::TypeName<T>()			\
	+std::string("> '")+GetFullTypeName()				\
	+std::string("'");						\
    }									\
    static Pointer New()						\
      {									\
	bbtkDebugMessage("object",1,"##> "<<BBTK_STRINGIFY(CLASS)	\
			 <<"Descriptor<"<<bbtk::TypeName<T>()<<">::New"	\
			 <<std::endl);					\
	Pointer p = MakePointer(new Self());				\
	bbtkDebugMessage("object",1,"<## "<<BBTK_STRINGIFY(CLASS)	\
			 <<"Descriptor<"<<bbtk::TypeName<T>()<<">::New"	\
			 <<std::endl);					\
	return p;							\
      }									\
    virtual bbtk::AtomicBlackBoxDescriptor::Pointer GetInstance()	const \
      {									\
	return Instance();						\
      }									\
    static bbtk::AtomicBlackBoxDescriptor::Pointer Instance()		\
      {									\
	static bbtk::AtomicBlackBoxDescriptor::WeakPointer i;		\
	bbtk::AtomicBlackBoxDescriptor::Pointer j;			\
	if (!i.lock()) { j = Self::New(); i = j; }			\
	return i.lock();						\
      }									\
    bbtk::BlackBox::Pointer NewBlackBox(const std::string& name)	\
    {									\
      return CLASS<T>::New(name);					\
    }									\
    CLASS ## Descriptor()						\
      {									\
	bbtkDebugMessage("object",2,"==> "<<#CLASS<<"Descriptor<"	\
			 <<bbtk::TypeName<T>()<<">::"			\
			 <<#CLASS<<"Descriptor()"<<std::endl);		

//============================================================================

//============================================================================
/// Ends a template AtomicBlackBox of template param T description block
#define BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(CLASS)			\
  bbtkDebugMessage("object",2,"<== "<<#CLASS<<"Descriptor<"		\
		   <<bbtk::TypeName<T>()<<">::"				\
		   <<#CLASS<<"Descriptor()"<<std::endl);		\
  }									\
  };									

//============================================================================

//============================================================================
/// Describes a template AtomicBlackBox input (to be put inside the template UBB description block)
#define BBTK_TEMPLATE_INPUT(CLASS,NAME,DESCR,TYPE)			\
  AddInputDescriptor(new bbtk::AtomicBlackBoxInputDescriptor		\
		     (typeid(CLASS ## Descriptor),#NAME,DESCR,"",	\
		      new bbtk::AtomicBlackBoxTGetFunctor<CLASS<T>,TYPE,TYPE > \
		      (&CLASS<T>::bbGetInput##NAME),			\
		      new bbtk::AtomicBlackBoxTSetFunctor<CLASS<T>,TYPE,TYPE > \
		      (&CLASS<T>::bbSetInput##NAME) ) )
//============================================================================

//============================================================================
/// Describes a template AtomicBlackBox output (to be put inside the template UBB description block)
#define BBTK_TEMPLATE_OUTPUT(CLASS,NAME,DESCR,TYPE)			\
  AddOutputDescriptor(new bbtk::AtomicBlackBoxOutputDescriptor		\
		      (typeid(CLASS ## Descriptor),#NAME,DESCR,"",	\
		       new bbtk::AtomicBlackBoxTGetFunctor<CLASS<T>,TYPE,TYPE > \
		       (&CLASS<T>::bbGetOutput##NAME),			\
		       new bbtk::AtomicBlackBoxTSetFunctor<CLASS<T>,TYPE,TYPE > \
		       (&CLASS<T>::bbSetOutput##NAME) ) )
//============================================================================


//JCP 09JUIN2009 BBTK_EXPORT

//============================================================================
/// Template AtomicBlackBox std implementation of ctor and dtor
#define BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(CLASS,PARENT)		\
  template <class T>							\
  CLASS<T>::CLASS(const std::string& name, bool alloc)			\
    : PARENT(name,false)						\
  {									\
    BBTK_BEGIN_BLACK_BOX_CONSTRUCTOR(CLASS,alloc);			\
    CLASS<T>::bbUserSetDefaultValues();					\
    BBTK_END_BLACK_BOX_CONSTRUCTOR(CLASS);				\
  }									\
  template <class T>							\
  CLASS<T>::CLASS(CLASS<T>& from,					\
		  const std::string& name, bool allocate_connectors)	\
    : PARENT(from,name,false)						\
  {									\
    BBTK_BEGIN_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,from,allocate_connectors); \
    CLASS<T>::bbUserSetDefaultValues();					\
    BBTK_END_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,from,allocate_connectors);			\
  }									\
  template <class T>							\
  CLASS<T>::~CLASS()							\
  {									\
    BBTK_BEGIN_BLACK_BOX_DESTRUCTOR(CLASS);				\
    BBTK_END_BLACK_BOX_DESTRUCTOR(CLASS);				\
  }									\
  template <class T>							\
  void CLASS<T>::bbLockDescriptor()					\
  {									\
    bbmDescriptorPointer = CLASS ## Descriptor<T>::Instance();		\
  }
//============================================================================



//============================================================================
// Two template params user black boxes macros
//============================================================================

//============================================================================
#define BBTK_TEMPLATE2_BLACK_BOX_INTERFACE(CLASS,PARENT,T1,T2)	\
  public : typedef CLASS<T1,T2> Self;					\
  BBTK_BLACK_BOX_INTERFACE_INTERNAL(CLASS,PARENT);
//===========================================================================

//============================================================================
/// Begins a template AtomicBlackBox description block of template param T1 and T2 
#define BBTK_BEGIN_DESCRIBE_TEMPLATE2_BLACK_BOX(CLASS,PARENT)		\
  template <class T1, class T2>						\
  class /*BBTK_EXPORT*/ CLASS ## Descriptor : public PARENT ## Descriptor \
  {									\
  public: typedef CLASS ## Descriptor<T1,T2> Self;			\
    BBTK_OBJECT_MINIMAL_INTERFACE;					\
  public:								\
    std::string GetObjectName() const					\
    {									\
      return std::string(BBTK_STRINGIFY(CLASS))				\
	+std::string("Descriptor<")+bbtk::TypeName<T1>()		\
	+std::string(",")+bbtk::TypeName<T2>()				\
	+std::string("> '")+GetFullTypeName()				\
	+std::string("'");						\
    }									\
    static Pointer New()						\
      {									\
	bbtkDebugMessage("object",1,"##> "<<BBTK_STRINGIFY(CLASS)	\
			 <<"Descriptor<"<<bbtk::TypeName<T1>()<<","	\
			 <<bbtk::TypeName<T2>()<<">::New"<<std::endl);	\
	Pointer p = MakePointer(new Self());				\
	bbtkDebugMessage("object",1,"<## "<<BBTK_STRINGIFY(CLASS)	\
			 <<"Descriptor<"<<bbtk::TypeName<T1>()<<","	\
			 <<bbtk::TypeName<T2>()<<">::New"<<std::endl);	\
	return p;							\
      }									\
    virtual bbtk::AtomicBlackBoxDescriptor::Pointer GetInstance() const \
      {									\
	return Instance();						\
      }									\
    static bbtk::AtomicBlackBoxDescriptor::Pointer Instance()		\
      {									\
	static bbtk::AtomicBlackBoxDescriptor::WeakPointer i;		\
	bbtk::AtomicBlackBoxDescriptor::Pointer j;			\
	if (!i.lock()) { j = Self::New(); i = j; }			\
	return i.lock();						\
      }									\
    bbtk::BlackBox::Pointer NewBlackBox(const std::string& name)	\
    {									\
      return CLASS<T1,T2>::New(name);					\
    }									\
    CLASS ## Descriptor()						\
      {									\
	bbtkDebugMessage("object",2,"==> "<<#CLASS<<"Descriptor<"	\
			 <<bbtk::TypeName<T1>()<<","			\
			 <<bbtk::TypeName<T2>()<<">::"			\
			 <<#CLASS<<"Descriptor()"<<std::endl);		
//============================================================================

//============================================================================
/// Ends a template AtomicBlackBox description block of template param T1 and T2
#define BBTK_END_DESCRIBE_TEMPLATE2_BLACK_BOX(CLASS)			\
  bbtkDebugMessage("object",2,"<== "<<#CLASS<<"Descriptor<"		\
		   <<bbtk::TypeName<T1>()<<","				\
		   <<bbtk::TypeName<T2>()<<">::"			\
		   <<#CLASS<<"Descriptor()"<<std::endl);		\
  }									\
  };									

//============================================================================



/*
//============================================================================
// Two template params user black boxes macros

/// Begins a template AtomicBlackBox description block of template param T1 and T2 
#define BBTK_BEGIN_DESCRIBE_TEMPLATE2_WITH_TYPES_BLACK_BOX(CLASS,TYPE1,TYPE2)		\
  template <TYPE1 T1, TYPE2 T2>						\
  class  CLASS ## Descriptor : public bbtk::BlackBoxDescriptor		\
  {									\
  public:								\
    virtual bbtk:AtomicBlackBoxDescriptor::Pointer GetInstance()	const	\
      {									\
	return Instance();						\
      }									\
    static bbtk:AtomicBlackBoxDescriptor::Pointer Instance()			\
      {									\
	static bbtk:AtomicBlackBoxDescriptor::WeakPointer i;			\
	bbtk:AtomicBlackBoxDescriptor::Pointer j;				\
	if (!i.lock()) { j = Self::New(); i = j; }			\
	return i.lock();						\
      }									\
    bbtk::BlackBox::Pointer NewBlackBox(const std::string& name)	\
    {									\
      return new CLASS<T1,T2>(name);					\
    }									\
    CLASS ## Descriptor()						\
      {									\
      bbtkDebugMessageInc("Kernel",9,#CLASS<<"Descriptor::"<<#CLASS	\
			  <<"Descriptor()"<<std::endl)
//============================================================================

//============================================================================
/// Ends a template AtomicBlackBox description block of template param T1 and T2
#define BBTK_END_DESCRIBE_TEMPLATE2_WITH_TYPES_BLACK_BOX(CLASS,TYPE1,TYPE2)	\
  bbtkDecTab("Kernel",9);							\
  }									\
  };									

//============================================================================

*/

//============================================================================
/// Describes a 2 template params AtomicBlackBox input (to be put inside the UBB description block)
#define BBTK_TEMPLATE2_INPUT(CLASS,NAME,DESCR,TYPE)			\
  AddInputDescriptor(new bbtk::AtomicBlackBoxInputDescriptor		\
		     (typeid(CLASS ## Descriptor),#NAME,DESCR,"",	\
		      new bbtk::AtomicBlackBoxTGetFunctor<CLASS<T1,T2>,TYPE,TYPE >	\
		      (&CLASS<T1,T2>::bbGetInput##NAME),		\
		      new bbtk::AtomicBlackBoxTSetFunctor<CLASS<T1,T2>,TYPE,TYPE >	\
		      (&CLASS<T1,T2>::bbSetInput##NAME) ) )
//============================================================================

//============================================================================
/// Describes a 2 template params AtomicBlackBox output (to be put inside the UBB description block)
#define BBTK_TEMPLATE2_OUTPUT(CLASS,NAME,DESCR,TYPE)			\
  AddOutputDescriptor(new bbtk::AtomicBlackBoxOutputDescriptor		\
		      (typeid(CLASS ## Descriptor),#NAME,DESCR,"",	\
		       new bbtk::AtomicBlackBoxTGetFunctor<CLASS<T1,T2>,TYPE,TYPE > \
		       (&CLASS<T1,T2>::bbGetOutput##NAME),		\
		       new bbtk::AtomicBlackBoxTSetFunctor<CLASS<T1,T2>,TYPE,TYPE > \
		       (&CLASS<T1,T2>::bbSetOutput##NAME) ) )
//============================================================================

//============================================================================
/// Template AtomicBlackBox std implementation of ctor and dtor
#define BBTK_BLACK_BOX_TEMPLATE2_IMPLEMENTATION(CLASS,PARENT)		\
  template <class T1, class T2>						\
  CLASS<T1,T2>::CLASS(const std::string& name, bool alloc)		\
    : PARENT(name,false)						\
  {									\
    BBTK_BEGIN_BLACK_BOX_CONSTRUCTOR(CLASS,alloc);			\
    CLASS<T1,T2>::bbUserSetDefaultValues();				\
    BBTK_END_BLACK_BOX_CONSTRUCTOR(CLASS);				\
  }									\
  template <class T1, class T2>						\
  CLASS<T1,T2>::CLASS(CLASS<T1,T2>& from,				\
		      const std::string& name, bool allocate_connectors) \
    : PARENT(from,name,false)						\
  {									\
    BBTK_BEGIN_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,from,allocate_connectors); \
    CLASS<T1,T2>::bbUserSetDefaultValues();				\
    BBTK_END_BLACK_BOX_COPY_CONSTRUCTOR(CLASS,from,allocate_connectors);			\
  }									\
  template <class T1, class T2>						\
  CLASS<T1,T2>::~CLASS()						\
  {									\
    BBTK_BEGIN_BLACK_BOX_DESTRUCTOR(CLASS);				\
    BBTK_END_BLACK_BOX_DESTRUCTOR(CLASS);				\
  }									\
  template <class T1, class T2>						\
  void CLASS<T1,T2>::bbLockDescriptor()					\
  {									\
    bbmDescriptorPointer = CLASS ## Descriptor<T1,T2>::Instance();	\
  }
//============================================================================





//===========================================================================
/// EOF
//===========================================================================
#endif
