/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

/*=========================================================================
Program:   bbtk
Module:    $RCSfile$
Language:  C++
Date:      $Date$
Version:   $Revision$
=========================================================================*/


#ifndef __bbtkBBPInterpreter_h__
#define __bbtkBBPInterpreter_h__

//Includes bbtk
#include "bbtkInterpreterVirtual.h"

//Includes std
#include <iostream>
#include <set>


//#include "bbtkSystem.h"
//#include "bbtkComplexBlackBox.h"

namespace bbtk
{
  class BBTK_EXPORT BBPInterpreter : public InterpreterVirtual
  {
  public:
    static Pointer New();
    BBPInterpreter();
    ~BBPInterpreter();

    //Public methods

    virtual void commandNew( const std::string& boxType, const std::string& boxName);

    virtual void commandConnection (const std::string &boxfrom,
                       const std::string &output,
                       const std::string &boxto,
                       const std::string &input);
    virtual void commandSet(const std::string &box,const std::string &input,const std::string &value);


    virtual void commandDefine(const std::string &name,const std::string &pack,const std::string &scriptfilename);
    virtual void commandEndDefine();

    virtual void commandExec(const std::string &word);

    virtual void commandAuthor(const std::string &author);
    virtual void commandCategory(const std::string &categorytype);
    virtual void commandDescription(const std::string &description);

    virtual void commandInput(const std::string &name,const std::string &box,const std::string &input,const std::string  &help);
    virtual void commandOutput(const std::string &name,const std::string &box,const std::string &output,const std::string  &help);

    std::string boxName;
    std::set<std::string> dependencies;

  private:

    //Private Attributes

    //Private Methods

  protected:

    //Protected Attributes

    //Protected methods

  };
}
// namespace bbtk
#endif

