/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkBlackBoxInputConnector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.9 $
=========================================================================*/


/**
 *  \file 
 *  \brief Class bbtk::BlackBoxInputConnector : 
 */
/**
 * \class bbtk::BlackBoxInputConnector
 * \brief 
 */
 
#ifndef __bbtkBlackBoxInputConnector_h__
#define __bbtkBlackBoxInputConnector_h__

#include "bbtkConnection.h"
#include "bbtkPimpl.h"
#include <vector>

namespace bbtk
{

  class BlackBox;
  BBTK_FORWARD_DECLARE_POINTER(BlackBox);

  class BBTK_EXPORT BlackBoxInputConnector 
  {
  public:
     
    /// Ctor
    BlackBoxInputConnector(BlackBoxPointer b);
    /// Dtor
    ~BlackBoxInputConnector();    

    /// Sets a connection
    void SetConnection(Connection* c);
    /// Unsets the connection 
    /// The parameter is USELESS today but would be useful if we allow multiple connections on inputs
    void UnsetConnection(Connection* c);
    /// Returns the connection plugged into this input (const)
    Connection* GetConnection() const;
    /// Returns true iff a connection is connected to it
    bool IsConnected() const;
    

    // Recursive execution
    void RecursiveExecute();


    /// Returns the status of the input 
    IOStatus GetStatus() const;
    /// Sets the status of the input 
    void SetStatus(IOStatus s);
    
    /// Returns the black box which owns the connector
    BlackBoxPointer GetBlackBox() const;


    /// Private implementation
    BBTK_DECLARE_PIMPL(BlackBoxInputConnector);
 
  private:
    /// Purposedly not implemented
    BlackBoxInputConnector(const BlackBoxInputConnector&);
  };
  
}
// namespace bbtk
#endif
