/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkBlackBoxOutputDescriptor.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.6 $
=========================================================================*/

                                                                     


/**
 *  \file 
 *  \brief Class bbtk::BlackBoxOutputDescriptor : abstract descriptor of an output of a black box (stores a name, a description and type)
 */
/**
 * \class bbtk::BlackBoxOutputDescriptor
 * \brief Abstract descriptor of an output of a black box (stores a name, a description and type)
 */

#ifndef __bbtkBlackBoxOutputDescriptor_h__
#define __bbtkBlackBoxOutputDescriptor_h__

#include "bbtkBlackBoxInputOutputDescriptor.h"

namespace bbtk
{
  
  class BBTK_EXPORT BlackBoxOutputDescriptor
    : public BlackBoxInputOutputDescriptor
  {
  public:
    /// Ctor with name and description
    BlackBoxOutputDescriptor( TypeInfo creator_type_info,
			      const std::string& name,
			      const std::string& description,
			      const std::string& nature,
			      bool copy_construct = true)
      : BlackBoxInputOutputDescriptor(creator_type_info,name,
				      description,
				      nature,
				      copy_construct)
    {}
 
  protected:
    /// Default ctor is reserved to children
    BlackBoxOutputDescriptor() : 
      BlackBoxInputOutputDescriptor()
    {}
 };
  
}
// namespace bbtk
#endif
