/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkPimpl.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.3 $
=========================================================================*/



#ifndef __bbtkPimpl_h_INCLUDED__
#define __bbtkPimpl_h_INCLUDED__


/** \brief Macro defining the members used to hide a class implementation details using the pimpl idom	
 *    /// See http://c2.com/cgi/wiki?PimplIdiom
 * NOTE :
 *  - Defines the struct Pimpl to be implemented in cpp file
 *  - Declares a private member called p
 *  - Declares the methods PimplConstruct/PimplCopyConstruct/PimplDestruct
 */
#define BBTK_DECLARE_PIMPL(CLASS)				      \
  private:							      \
  /* The Pimpl struct forward definition */			      \
  class Pimpl;							      \
  /* The Pimpl pointer */					      \
  Pimpl* p;							      \
  /* Constructs the Pimpl (to be called in all Ctors) */	      \
  void PimplConstruct();					      \
  /* Copy constructs the Pimpl (to be called in copy Ctor) */	      \
  void PimplCopyConstruct(const CLASS&);			      \
  /* Destructs the Pimpl (to be called in Dtor) */		      \
  void PimplDestruct();

#endif

/** \brief Macro implementing the PimplConstruct/PimplCopyConstruct/PimplDestruct method declared by BBTK_DECLARE_PIMPL: to be put in cpp **/
#define BBTK_IMPL_PIMPL(CLASS)						\
  void CLASS::PimplConstruct()						\
  {									\
    p = new Pimpl;							\
  }									\
  void CLASS::PimplCopyConstruct(const CLASS& o)			\
  {									\
    p = new Pimpl(*(o.p));						\
  }									\
  void CLASS::PimplDestruct()						\
  {									\
    delete p;								\
  }									


