/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkTypeMapping.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.3 $
=========================================================================*/




#ifndef __bbtkTypeMapping_h_INCLUDED__
#define __bbtkTypeMapping_h_INCLUDED__


namespace bbtk 
{

/// 
template <typename ValueType>
class TypeMapping 
{
public:
  TypeMapping() {}

  template <typename T>
  ValueType& value() 
  {
    return m_map[ (void*)typeid(T).name() ];
  }
  template <typename T>
  ValueType& operator[]( const T& ) 
  {
    return m_map[ (void*)typeid(T).name() ];
  }

  ValueType& operator[]( const std::type_info& t) 
  {
    return m_map[ (void*)t.name() ];
  }
  
  unsigned int size() const { return m_map.size(); }

  typedef typename std::map<void*, ValueType>::const_iterator const_iterator;

  const_iterator begin() const { return m_map.begin(); }
  const_iterator end() const { return m_map.end(); }

protected:
  std::map<void*, ValueType> m_map;
};



}
#endif
