/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkQt.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.3 $
=========================================================================*/



#ifndef __bbtkWt_h_INCLUDED__
#define __bbtkWt_h_INCLUDED__

//===========================================================================
// SIGNAL/SLOT MECHANISM 
// FOR bbtk WINDOWS CREATION/DESTRUCTION OBSERVATION 
// BBTKWXSIG

//EED 2020-03-17
//#include <boost/signal.hpp>
#include <boost/signals2/signal.hpp>

#include <boost/bind.hpp>

//typedef boost::signals::trackable SignalObserver;
// \BBTKWXSIG
//===========================================================================


//===========================================================================
// Wt headers
// DEFINIR LOS HEADERS Wt que se necesitan  *-*-*-*-*-*-*-*-*-*
#ifdef USE_WT

//TODO Include libs in the CMake escription
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WWidget>
#include <Wt/WCheckBox>
#include <Wt/WServer>
#include <Wt/WText>
#include <Wt/WPushButton>
#include <Wt/WSlider>
#include <Wt/WHBoxLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WBorderLayout>
#include <Wt/WLineEdit>
#include <Wt/WComboBox>
#include <Wt/WSelectionBox>
#include <Wt/WGroupBox>
#include <Wt/WRadioButton>
#include <Wt/WButtonGroup>
#include <Wt/WLayout>
#include <Wt/WHBoxLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WRadioButton>
#include <Wt/Ext/Splitter>
#include <Wt/WTabWidget>
#include <Wt/WFileUpload>
#include <Wt/WLength>


#else //USE_WT

#endif // EO USE_WT




#ifdef USE_WT


// Definition of some classes used in tehe code
typedef Wt::WEnvironment WtWEnvironment;
typedef Wt::WWidget WtWWidget;
//typedef Wt::WContainerWidget WtWContainerWidget;
typedef Wt::WApplication WtWApplication;
typedef Wt::WString WtWString;



#else // EO_USE_WT


typedef void WtWidget;
typedef void WtWContainerWidget;
typedef void WtWApplication;
typedef void WtBusyCursor;

#endif // EO USE_WT


//==========================================================================

//===========================================================================
#include "bbtkSystem.h"
//===========================================================================





namespace bbtk
{

  //==================================================================
  /// Global wt handlers (cursor...)


// BBTKWXSIG BBTK_ADD_BLACK_BOX_TO_PACKAGE(MyProjectWT,Testing)

#define bbtkAddWtSignalObserver(METHOD)		\
  WWt::AddSignalObserver(boost::bind(&METHOD, this))
// \BBTKWXSIG

#define BBTK_BUSY_CURSOR bbtk::WWt::BusyCursor __bbtk_dummy_busy_cursor;

  struct BBTK_EXPORT WWt
  {	
  public:
    // BBTKWXSIG
    // The keyword 'signals' is also a macro in qt
    //    typedef boost::signals::trackable SignalObserver;

//EED 2020-04-21
//    typedef boost::signals::trackable SignalObserver;
//    typedef boost::signal<void ()>  Signal_type;
      
    typedef boost::signals2::trackable SignalObserver;
    typedef boost::signals2::signal<void ()>  Signal_type;

    typedef Signal_type::slot_function_type Slot_function_type;
    // \BBTKWXSIG
		
    /*
    static void ResetCursor();
    static void BeginBusyCursor(); 
    static void EndBusyCursor();
    */

    static void LoopUntilAllWindowsClose();

    class BusyCursor
    {
    public:
      BusyCursor();
      ~BusyCursor();
      //wxBusyCursor* mCursor; The wxBusyCursor is only for comunicate to the client/user that the program is busy. 
    };


    static void ProcessPendingEvents();

#ifdef USE_WT
    /// Sets the parent of all bbtk windows
    static void SetTopWindow(Wt::WContainerWidget*);
    /// Returns the parent of all bbtk windows 
    static Wt::WContainerWidget* GetTopWindow();
#endif // EO USE_WT

    
    static void IncNbWindowsAlive();
    static void DecNbWindowsAlive();
    static int  GetNbWindowsAlive();
    static bool IsSomeWindowAlive();
    

    // BBTKWXSIG
    static void AddSignalObserver(Slot_function_type);
    // \BBTKWXSIG




  //private:
    static void CreateWtAppIfNeeded();
    static void DestroyWtAppIfNeeded();

  }; // struct Wt
  //==================================================================
  
#ifdef USE_WT


	static std::string jScript;
  //==================================================================
  /// Conversion std::string to wxString 
  inline Wt::WString std2wt(const std::string& s)
  {
  //  Wt::WString wt;
/*
    const char* my_string=s.c_str();
    wxMBConvUTF8 *wxconv= new wxMBConvUTF8();
    wx=wxString(wxconv->cMB2WC(my_string),wxConvUTF8);
    delete wxconv;
    // test if conversion works of not. In case it fails convert from Ascii
    if(wx.length()==0)
      wx=wxString(wxString::FromAscii(s.c_str()));
*/	
    return Wt::WString::fromUTF8(s,false);
    //return new Wt::WString(s);//wt;
  }
  //==================================================================

  //==================================================================
  /// Conversion wxString to std::string
  inline  std::string wt2std(const Wt::WString& s){
   /* std::string s2;
    if(s.wxString::IsAscii()) {
      s2=s.wxString::ToAscii();
    } else {
      const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(s);
      const char *tmp_str = (const char*) tmp_buf;
      s2=std::string(tmp_str, strlen(tmp_str));
    }

    return s2;*/
	return s.toUTF8();
  }
  //==================================================================
#endif // EO _USE_WXWIDGETS




  
} // namespace bbtk
  

#endif // EO __bbtkWt_h_INCLUDED__
