/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWx.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.13 $
=========================================================================*/




#ifndef __bbtkWx_h_INCLUDED__
#define __bbtkWx_h_INCLUDED__

//===========================================================================
// Wx headers
#ifdef USE_WXWIDGETS
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"
#include <wx/datetime.h>


#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#ifdef __WXGTK__
# include <locale.h>
#endif //__WXGTK__
// EO Wx headers

#else //USE_WXWIDGETS

// define wxWindow
typedef void wxWindow;
typedef void wxBusyCursor;

#endif // EO USE_WXWIDGETS
//===========================================================================

//===========================================================================
#include "bbtkSystem.h"
//===========================================================================

//===========================================================================
// SIGNAL/SLOT MECHANISM 
// FOR bbtk WINDOWS CREATION/DESTRUCTION OBSERVATION 
// BBTKWXSIG
#include <boost/signals2/signal.hpp>
#include <boost/bind.hpp>
// \BBTKWXSIG
//===========================================================================

namespace bbtk
{

  //==================================================================
  /// Global wx handlers (cursor...)
  
// BBTKWXSIG
#define bbtkAddWxSignalObserver(METHOD)		\
  Wx::AddSignalObserver(boost::bind(&METHOD, this))
// \BBTKWXSIG

#define BBTK_BUSY_CURSOR bbtk::Wx::BusyCursor __bbtk_dummy_busy_cursor;

  struct BBTK_EXPORT Wx
  {	
  public:
    // BBTKWXSIG
    typedef boost::signals2::trackable SignalObserver;
    typedef boost::signals2::signal<void ()>  Signal_type;
    typedef Signal_type::slot_function_type Slot_function_type;
    // \BBTKWXSIG

    class BusyCursor
    {
    public:
      BusyCursor();
      ~BusyCursor();
      wxBusyCursor* mCursor;
    };

    static void ProcessPendingEvents();
    
    /// Sets the parent of all bbtk windows
    static void SetTopWindow(wxWindow*);
    /// Returns the parent of all bbtk windows 
    static wxWindow* GetTopWindow();


    static void IncNbWindowsAlive();
    static void DecNbWindowsAlive();
    static int  GetNbWindowsAlive();
    static bool IsSomeWindowAlive();
    
     // BBTKWXSIG
    static void AddSignalObserver(Slot_function_type);
    // \BBTKWXSIG

  
  private:

    static void CreateWxAppIfNeeded();
    static void DestroyWxAppIfNeeded();

  }; // struct Wx
  //==================================================================


#ifdef USE_WXWIDGETS
  //==================================================================
  /// Conversion std::string to wxString 
  inline wxString std2wx(const std::string& s){
    wxString wx;
    const char* my_string=s.c_str();
    wxMBConvUTF8 *wxconv= new wxMBConvUTF8();
    wx=wxString(wxconv->cMB2WC(my_string),wxConvUTF8);
    delete wxconv;
    // test if conversion works of not. In case it fails convert from Ascii
    if(wx.length()==0)
      wx=wxString(wxString::FromAscii(s.c_str()));
    return wx;
  }
  //==================================================================

  //==================================================================
  /// Conversion wxString to std::string
  inline std::string wx2std(const wxString& s){
    std::string s2;
    if(s.wxString::IsAscii()) {
      s2=s.wxString::ToAscii();
    } else {
      const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(s);
      const char *tmp_str = (const char*) tmp_buf;
      s2=std::string(tmp_str, strlen(tmp_str));
    }
    return s2;
  }
  //==================================================================
#endif // EO _USE_WXWIDGETS

  
} // namespace bbtk
  

#endif // EO __bbtkWx_h_INCLUDED__
