/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkXML.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.6 $
=========================================================================*/



#ifndef __bbtkXML_h_INCLUDED__
#define __bbtkXML_h_INCLUDED__

#include "xmlParser.h"
#include <sstream>

namespace bbtk
{
	void CleanString_0D(std::string& var)
	{
		int i,size=var.length();
		for (i=1 ; i<size ; i++ )
		{
			if ((var[i-1]==13) && (var[i]==10) )
			{
				var[i-1]=32;  // space
			} //if
		} // for
	}

  //====================================================================
  inline bool GetTextOrClear(const XMLNode& node, std::string& var)
  {
    if (node.nText()>0) 
      {
	var = node.getText();
	CleanString_0D(var);
	return true;
      }
    else if (node.nClear()>0) 
      {
	var = node.getClear().lpszValue;
	CleanString_0D(var);
	return true;
      }
    else 
      {
	return false;
      }
  }
  //====================================================================

  std::string GetErrorMessage(XMLResults* res, const std::string& filename)
  {
    std::ostringstream str;
    str << XMLNode::getError(res->error);
    str << " [line " << res->nLine << ", col "<<res->nColumn<<"] ";
    str << " file "<<filename; 
    return str.str();
  }
};

#endif
